/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.JUnitService;
import io.hawt.util.ReflectionHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class DefaultJUnitService
implements JUnitService {
    @Override
    public List<Method> findTestMethods(Class<?> clazz) throws Exception {
        Class<? extends Annotation> ann = DefaultJUnitService.loadAnnotationClass(clazz, "org.junit.Test");
        List<Method> annotations = DefaultJUnitService.findMethodsWithAnnotation(clazz, ann, false);
        List<Method> names = DefaultJUnitService.findMethodsWithName(clazz, "test*");
        ArrayList<Method> answer = new ArrayList<Method>();
        for (Method method : annotations) {
            if (answer.contains(method)) continue;
            answer.add(method);
        }
        for (Method method : names) {
            if (answer.contains(method)) continue;
            answer.add(method);
        }
        return answer;
    }

    @Override
    public List<Method> filterTestMethods(List<Method> methods, String filter) {
        boolean wildcard;
        boolean bl = wildcard = filter != null && filter.endsWith("*");
        if (wildcard) {
            filter = filter.substring(0, filter.length() - 1);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        if (filter != null) {
            for (Method method : methods) {
                if (wildcard && method.getName().startsWith(filter)) {
                    result.add(method);
                    continue;
                }
                if (!method.getName().equals(filter)) continue;
                result.add(method);
            }
        } else {
            result.addAll(methods);
        }
        return result;
    }

    @Override
    public Method findBefore(Class<?> clazz) throws Exception {
        Class<? extends Annotation> ann = DefaultJUnitService.loadAnnotationClass(clazz, "org.junit.Before");
        List<Method> annotations = DefaultJUnitService.findMethodsWithAnnotation(clazz, ann, false);
        if (!annotations.isEmpty()) {
            return annotations.get(0);
        }
        List<Method> names = DefaultJUnitService.findMethodsWithName(clazz, "setUp");
        if (!names.isEmpty()) {
            return names.get(0);
        }
        return null;
    }

    @Override
    public Method findBeforeClass(Class<?> clazz) throws Exception {
        Class<? extends Annotation> ann = DefaultJUnitService.loadAnnotationClass(clazz, "org.junit.BeforeClass");
        List<Method> annotations = DefaultJUnitService.findMethodsWithAnnotation(clazz, ann, false);
        if (!annotations.isEmpty()) {
            return annotations.get(0);
        }
        return null;
    }

    @Override
    public Method findAfter(Class<?> clazz) throws Exception {
        Class<? extends Annotation> ann = DefaultJUnitService.loadAnnotationClass(clazz, "org.junit.After");
        List<Method> annotations = DefaultJUnitService.findMethodsWithAnnotation(clazz, ann, false);
        if (!annotations.isEmpty()) {
            return annotations.get(0);
        }
        List<Method> names = DefaultJUnitService.findMethodsWithName(clazz, "tearDown");
        if (!names.isEmpty()) {
            return names.get(0);
        }
        return null;
    }

    @Override
    public Method findAfterClass(Class<?> clazz) throws Exception {
        Class<? extends Annotation> ann = DefaultJUnitService.loadAnnotationClass(clazz, "org.junit.AfterClass");
        List<Method> annotations = DefaultJUnitService.findMethodsWithAnnotation(clazz, ann, false);
        if (!annotations.isEmpty()) {
            return annotations.get(0);
        }
        return null;
    }

    private static Class<? extends Annotation> loadAnnotationClass(Class<?> clazz, String annotationClassName) throws ClassNotFoundException {
        return clazz.getClassLoader().loadClass(annotationClassName).asSubclass(Annotation.class);
    }

    private static List<Method> findMethodsWithName(Class<?> type, String namePattern) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!DefaultJUnitService.matchPattern(method.getName(), namePattern)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    private static List<Method> findMethodsWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType, boolean checkMetaAnnotations) {
        ArrayList<Method> answer = new ArrayList<Method>();
        do {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                if (!ReflectionHelper.hasAnnotation((AnnotatedElement)method, annotationType, (boolean)checkMetaAnnotations)) continue;
                answer.add(method);
            }
        } while ((type = type.getSuperclass()) != null);
        return answer;
    }

    private static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equals(pattern)) {
            return true;
        }
        if (DefaultJUnitService.matchWildcard(name, pattern)) {
            return true;
        }
        return DefaultJUnitService.matchRegex(name, pattern);
    }

    private static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    private static boolean matchRegex(String name, String pattern) {
        try {
            if (name.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }
}

