/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.InProgressDTO;
import io.hawt.junit.InProgressRunListener;
import io.hawt.junit.JUnitFacadeMBean;
import io.hawt.junit.ResultDTO;
import io.hawt.util.MBeanSupport;
import io.hawt.util.introspect.support.ClassScanner;
import java.util.List;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitFacade
extends MBeanSupport
implements JUnitFacadeMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(JUnitFacade.class);
    private static JUnitFacade singleton;
    private ClassScanner classScanner = ClassScanner.newInstance();
    private volatile InProgressDTO inProgress;

    public static JUnitFacade getSingleton() {
        if (singleton == null) {
            LOG.warn("No JUnitFacade constructed yet so using default configuration for now");
            singleton = new JUnitFacade();
        }
        return singleton;
    }

    public void init() throws Exception {
        singleton = this;
        super.init();
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=JUnitFacade";
    }

    @Override
    public boolean isTestInProgress() {
        return this.inProgress != null;
    }

    @Override
    public InProgressDTO inProgress() throws Exception {
        return this.inProgress;
    }

    @Override
    public ResultDTO runTestClasses(List<String> classNames) throws Exception {
        this.inProgress = new InProgressDTO();
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)new InProgressRunListener(this.inProgress));
        List classes = this.classScanner.optionallyFindClasses(classNames);
        Class[] classArray = new Class[classes.size()];
        classes.toArray(classArray);
        Request request = Request.classes((Class[])classArray);
        Result result = core.run(request);
        return new ResultDTO(result);
    }
}

