/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.junit;

import io.hawt.junit.StackTraceDTO;
import java.util.ArrayList;
import java.util.List;

public class ThrowableDTO {
    private String localizedMessage;
    private String message;
    private List<StackTraceDTO> stackTraceList = new ArrayList<StackTraceDTO>();

    public static void addThrowableAndCauses(List<ThrowableDTO> exceptions, Throwable exception) {
        if (exception != null) {
            ThrowableDTO dto = new ThrowableDTO(exception);
            exceptions.add(dto);
            Throwable cause = exception.getCause();
            if (cause != null && cause != exception) {
                ThrowableDTO.addThrowableAndCauses(exceptions, cause);
            }
        }
    }

    public ThrowableDTO() {
    }

    public ThrowableDTO(Throwable exception) {
        this.message = exception.getMessage();
        this.localizedMessage = exception.getLocalizedMessage();
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        if (stackTraceElements != null) {
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                this.stackTraceList.add(new StackTraceDTO(stackTraceElement));
            }
        }
    }

    public String toString() {
        return "ThrowableDTO{message='" + this.message + '\'' + ", stackTraceList=" + this.stackTraceList + '}';
    }

    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public void setLocalizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<StackTraceDTO> getStackTraceList() {
        return this.stackTraceList;
    }

    public void setStackTraceList(List<StackTraceDTO> stackTraceList) {
        this.stackTraceList = stackTraceList;
    }
}

