/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util.introspect;

import io.hawt.util.introspect.ClassLoaderProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderProviders {
    private static final transient Logger LOG = LoggerFactory.getLogger(ClassLoaderProviders.class);

    public static ClassLoaderProvider createConstantProvider(final ClassLoader classLoader) {
        return new ClassLoaderProvider(){

            @Override
            public ClassLoader getClassLoader() {
                return classLoader;
            }

            public String toString() {
                return "ClassLoaderProvider(" + classLoader + ")";
            }
        };
    }

    public static ClassLoaderProvider createReflectionProvider(final Object instance, final Method method) {
        return new ClassLoaderProvider(){

            @Override
            public ClassLoader getClassLoader() {
                Object value = null;
                try {
                    value = method.invoke(instance, new Object[0]);
                }
                catch (InvocationTargetException te) {
                    Throwable e = te.getTargetException();
                    LOG.warn("Failed to invoke " + method + " on " + instance + ". " + e, e);
                }
                catch (Exception e) {
                    LOG.warn("Failed to invoke " + method + " on " + instance + ". " + e, (Throwable)e);
                }
                if (value != null) {
                    if (value instanceof ClassLoader) {
                        return (ClassLoader)value;
                    }
                    LOG.warn("Value returned from " + method + " on " + instance + " is not a ClassLoader: " + value);
                }
                return null;
            }

            public String toString() {
                return "ReflectionClassLoaderProvider(" + instance + ", " + method + ")";
            }
        };
    }
}

