/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.WriteContext;
import io.hawt.util.Closeables;
import io.hawt.util.Zips;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(GitHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUploadFiles(WriteContext context, File folder, boolean unzip, List<File> uploadedFiles) throws IOException, GitAPIException {
        if (uploadedFiles != null) {
            for (File uploadedFile : uploadedFiles) {
                String name = uploadedFile.getName();
                if (unzip && name.endsWith(".zip")) {
                    File unzipDir = uploadedFile.getParentFile();
                    ZipInputStream zis = new ZipInputStream(new FileInputStream(uploadedFile));
                    try {
                        ZipEntry entry = zis.getNextEntry();
                        if (!entry.isDirectory()) {
                            String folderName = name.substring(0, name.length() - 4);
                            unzipDir = new File(uploadedFile.getParentFile(), folderName);
                        }
                    }
                    finally {
                        Closeables.closeQuietly(zis);
                    }
                    Zips.unzip(new FileInputStream(uploadedFile), unzipDir);
                    uploadedFile.delete();
                    uploadedFile = unzipDir;
                }
                LOG.info("Adding to folder: " + folder + " file: " + uploadedFile + " to git");
                context.addFile(uploadedFile);
            }
        }
    }
}

