/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.util.ArrayList;
import java.util.List;

public class Strings {
    public static String trimString(String value, int max) {
        if (value == null) {
            return "";
        }
        if (value.length() <= max) {
            return value;
        }
        return value.substring(0, max - 3) + "...";
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNotBlank(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String sanitize(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return name.replaceAll("[^0-9a-zA-Z\\+\\.\\(\\)_\\-]", "");
    }

    public static String sanitizeDirectory(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return Strings.sanitize(name).replace(".", "");
    }

    public static List<String> split(String text, String delimiter) {
        if (text == null || delimiter == null) {
            throw new IllegalArgumentException("Both 'text' and 'delimiter' should not be null.");
        }
        ArrayList<String> answer = new ArrayList<String>();
        for (String s : text.split(delimiter)) {
            if (!Strings.isNotBlank(s = s.trim())) continue;
            answer.add(s);
        }
        return answer;
    }
}

