/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class CommitLimitFilter
extends CommitFilter {
    private final long limit;
    private long count;

    public CommitLimitFilter(long limit) {
        this.limit = limit;
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        return this.include(this.count++ < this.limit);
    }

    @Override
    public CommitFilter reset() {
        this.count = 0L;
        return super.reset();
    }

    @Override
    public RevFilter clone() {
        return new CommitLimitFilter(this.limit);
    }
}

