/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Collection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.BlobUtils;
import org.gitective.core.filter.commit.CommitDiffFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDiffEditFilter
extends CommitDiffFilter {
    public CommitDiffEditFilter() {
    }

    public CommitDiffEditFilter(boolean detectRenames) {
        super(detectRenames);
    }

    protected CommitDiffEditFilter markStart(RevCommit commit) {
        return this;
    }

    protected CommitDiffEditFilter markEnd(RevCommit commit) {
        return this;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit, Collection<DiffEntry> diffs) {
        this.markStart(commit);
        ObjectReader reader = walker.getObjectReader();
        for (DiffEntry diff : diffs) {
            AbbreviatedObjectId oldId;
            if (!this.isFileDiff(diff) || (oldId = diff.getOldId()) == null || this.include(commit, diff, BlobUtils.diff(reader, oldId.toObjectId(), diff.getNewId().toObjectId()))) continue;
            return this.markEnd(commit).include(false);
        }
        this.markEnd(commit);
        return true;
    }

    protected boolean include(RevCommit commit, DiffEntry diff, Collection<Edit> edits) {
        for (Edit edit : edits) {
            if (this.include(commit, diff, edit)) continue;
            return false;
        }
        return true;
    }

    protected boolean include(RevCommit commit, DiffEntry diff, Edit edit) {
        return true;
    }
}

