/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.plugin.karaf.terminal;

import io.hawt.system.Helpers;
import io.hawt.web.plugin.karaf.terminal.CommandProcessorHolder;
import io.hawt.web.plugin.karaf.terminal.KarafConsoleFactory;
import io.hawt.web.plugin.karaf.terminal.TerminalServlet;
import io.hawt.web.plugin.karaf.terminal.ThreadIOHolder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.threadio.ThreadIO;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalServlet
extends HttpServlet {
    public static final int TERM_WIDTH = 120;
    public static final int TERM_HEIGHT = 400;
    private static final Logger LOG = LoggerFactory.getLogger(TerminalServlet.class);
    private static String KARAF2_FACTORY = "io.hawt.web.plugin.karaf.terminal.karaf2.Karaf2ConsoleFactory";
    private static String KARAF3_FACTORY = "io.hawt.web.plugin.karaf.terminal.karaf3.Karaf3ConsoleFactory";
    private volatile KarafConsoleFactory factory;
    private static final long serialVersionUID = 1L;

    public CommandProcessor getCommandProcessor() {
        return CommandProcessorHolder.getCommandProcessor();
    }

    public ThreadIO getThreadIO() {
        return ThreadIOHolder.getThreadIO();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String f;
        String str;
        String dump;
        HttpSession session = request.getSession(false);
        String token = request.getHeader("LoginToken");
        if (token == null || session == null) {
            Helpers.doForbidden((HttpServletResponse)response);
            return;
        }
        String sessionToken = (String)session.getAttribute("LoginToken");
        if (sessionToken == null || !token.equals(sessionToken)) {
            session.invalidate();
            Helpers.doForbidden((HttpServletResponse)response);
            return;
        }
        String encoding = request.getHeader("Accept-Encoding");
        boolean supportsGzip = encoding != null && encoding.toLowerCase().contains("gzip");
        SessionTerminal st = null;
        try {
            st = (SessionTerminal)session.getAttribute("terminal");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (st == null || st.isClosed()) {
            st = new SessionTerminal(this, this.getCommandProcessor(), this.getThreadIO());
            session = request.getSession(true);
            session.setAttribute("LoginToken", (Object)token);
            session.setAttribute("terminal", (Object)st);
        }
        if ((dump = st.handle(str = request.getParameter("k"), (f = request.getParameter("f")) != null && f.length() > 0)) != null) {
            if (supportsGzip) {
                response.setHeader("Content-Encoding", "gzip");
                response.setHeader("Content-Type", "text/html");
                try {
                    GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    gzos.write(dump.getBytes());
                    gzos.close();
                }
                catch (IOException ie) {
                    LOG.info("Exception writing response: ", (Throwable)ie);
                }
            } else {
                response.getOutputStream().write(dump.getBytes());
            }
        }
    }

    private BundleContext getBundleContext() {
        BundleContext bundleContext = null;
        Bundle currentBundle = FrameworkUtil.getBundle(this.getClass());
        if (currentBundle != null) {
            bundleContext = currentBundle.getBundleContext();
        }
        return bundleContext;
    }

    Object createConsole(CommandProcessor commandProcessor, PipedInputStream in, PrintStream pipedOut, ThreadIO threadIO, BundleContext bundleContext) throws Exception {
        Object answer = null;
        if (this.factory == null) {
            try {
                this.factory = (KarafConsoleFactory)bundleContext.getBundle().loadClass(KARAF2_FACTORY).newInstance();
                answer = this.factory.createConsole(commandProcessor, in, pipedOut, threadIO, bundleContext);
            }
            catch (Throwable e) {
                LOG.debug("Cannot create console using Karaf2 due " + e.getMessage());
            }
            if (answer == null) {
                try {
                    this.factory = (KarafConsoleFactory)bundleContext.getBundle().loadClass(KARAF3_FACTORY).newInstance();
                    answer = this.factory.createConsole(commandProcessor, in, pipedOut, threadIO, bundleContext);
                }
                catch (Throwable e) {
                    LOG.debug("Cannot create console using Karaf3 due " + e.getMessage());
                }
            }
        } else {
            answer = this.factory.createConsole(commandProcessor, in, pipedOut, threadIO, bundleContext);
        }
        if (answer == null) {
            throw new IllegalArgumentException("Cannot create console for terminal");
        }
        return answer;
    }

    static /* synthetic */ BundleContext access$000(TerminalServlet x0) {
        return x0.getBundleContext();
    }

    static /* synthetic */ KarafConsoleFactory access$100(TerminalServlet x0) {
        return x0.factory;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

