/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.plugin.karaf.terminal.karaf2;

import io.hawt.web.plugin.karaf.terminal.KarafConsoleFactory;
import io.hawt.web.plugin.karaf.terminal.WebTerminal;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.threadio.ThreadIO;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Karaf2ConsoleFactory
implements KarafConsoleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Karaf2ConsoleFactory.class);
    private static final String KARAF2_CONSOLE_CLASSNAME = "org.apache.karaf.shell.console.jline.Console";
    public static final int TERM_WIDTH = 120;
    public static final int TERM_HEIGHT = 400;

    public CommandSession getSession(Object console) {
        try {
            return (CommandSession)console.getClass().getMethod("getSession", null).invoke(console, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close(Object console, boolean param) {
        try {
            console.getClass().getMethod("close", Boolean.TYPE).invoke(console, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object createConsole(CommandProcessor commandProcessor, PipedInputStream in, PrintStream pipedOut, ThreadIO threadIO, BundleContext bundleContext) throws Exception {
        Class clazz2 = null;
        try {
            clazz2 = bundleContext.getBundle().loadClass(KARAF2_CONSOLE_CLASSNAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz2 != null) {
            Constructor<?> ctr = clazz2.getConstructors()[0];
            if (ctr.getParameterTypes().length <= 7) {
                LOG.debug("Using old Karaf 2.x Console API");
                BundleContext last = null;
                Class<?> type = ctr.getParameterTypes()[6];
                if (type != null && type.getSimpleName().equals("BundleContext")) {
                    last = bundleContext;
                }
                return ctr.newInstance(commandProcessor, in, pipedOut, pipedOut, new WebTerminal(120, 400), null, last);
            }
            LOG.debug("Using new Karaf 2.x Console API");
            BundleContext last = null;
            Class<?> type = ctr.getParameterTypes()[8];
            if (type != null && type.getSimpleName().equals("BundleContext")) {
                last = bundleContext;
            }
            return ctr.newInstance(commandProcessor, threadIO, in, pipedOut, pipedOut, new WebTerminal(120, 400), null, null, last);
        }
        return null;
    }
}

