/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.keystore;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hawt.keystore.CreateKeyStoreRequestDTO;
import io.hawt.keystore.KeystoreServiceMBean;
import io.hawt.keystore.SecurityProviderDTO;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreService
implements KeystoreServiceMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(KeystoreService.class);
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private ObjectMapper mapper = new ObjectMapper();

    public void init() {
        try {
            if (this.objectName == null) {
                this.objectName = new ObjectName("hawtio:type=KeystoreService");
            }
            if (this.mBeanServer == null) {
                this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                LOG.info("Re-registering KeystoreService MBean");
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception during initialization: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        try {
            if (this.objectName != null && this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception unregistering mbean: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public SecurityProviderDTO getSecurityProviderInfo() {
        ArrayList<String> supportedKeyStoreTypes = new ArrayList<String>();
        ArrayList<String> supportedKeyAlgorithms = new ArrayList<String>();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if ("KeyStore".equals(service.getType())) {
                    supportedKeyStoreTypes.add(service.getAlgorithm());
                    continue;
                }
                if (!"KeyPairGenerator".equals(service.getType())) continue;
                supportedKeyAlgorithms.add(service.getAlgorithm());
            }
        }
        SecurityProviderDTO result = new SecurityProviderDTO();
        result.supportedKeyStoreTypes = supportedKeyStoreTypes.toArray(new String[supportedKeyStoreTypes.size()]);
        result.supportedKeyAlgorithms = supportedKeyAlgorithms.toArray(new String[supportedKeyAlgorithms.size()]);
        return result;
    }

    @Override
    public String createKeyStoreViaJSON(String request) throws IOException {
        CreateKeyStoreRequestDTO r = (CreateKeyStoreRequestDTO)this.mapper.readValue(request, CreateKeyStoreRequestDTO.class);
        return Base64.encodeBase64String((byte[])this.createKeyStore(r));
    }

    @Override
    public byte[] createKeyStore(CreateKeyStoreRequestDTO request) throws IOException {
        int rc;
        File keystoreFile = File.createTempFile("keystore", ".jks");
        keystoreFile.delete();
        LOG.info("Generating ssl keystore...");
        String keytool = System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";
        if (request.createPrivateKey) {
            rc = this.system(keytool, "-genkey", "-storetype", request.storeType, "-storepass", request.storePassword, "-keystore", keystoreFile.getCanonicalPath(), "-keypass", request.keyPassword, "-alias", request.keyCommonName, "-keyalg", request.keyAlgorithm, "-keysize", "" + request.keyLength, "-dname", String.format("cn=%s", request.keyCommonName), "-validity", "" + request.keyValidity);
        } else {
            rc = this.system(keytool, "-genkey", "-storetype", request.storeType, "-storepass", request.storePassword, "-keystore", keystoreFile.getCanonicalPath(), "-dname", "cn=temp", "-keypass", "password", "-alias", "temp");
            if (rc != 0) {
                throw new IOException("keytool failed with exit code: " + rc);
            }
            rc = this.system(keytool, "-delete", "-storetype", request.storeType, "-storepass", request.storePassword, "-keystore", keystoreFile.getCanonicalPath(), "-alias", "temp");
        }
        if (rc != 0) {
            throw new IOException("keytool failed with exit code: " + rc);
        }
        byte[] keystore = KeystoreService.readBytes(keystoreFile);
        keystoreFile.delete();
        return keystore;
    }

    private int system(final String ... args) {
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            LOG.debug("Process failed to start: " + e, (Throwable)e);
            return -1;
        }
        new Thread("system command output processor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LOG.info(String.format("%s: %s", args[0], line));
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    KeystoreService.close(reader);
                }
            }
        }.start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            LOG.debug("Thread interrupted, killing process");
            process.destroy();
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    private static void close(Closeable reader) {
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        if (file == null) {
            throw new FileNotFoundException("No file specified");
        }
        try {
            int remaining;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            KeystoreService.close(fis);
            KeystoreService.close(bos);
            throw throwable;
        }
        KeystoreService.close(fis);
        KeystoreService.close(bos);
        return byArray;
    }
}

