/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.kubernetes;

import io.hawt.git.GitFacade;
import io.hawt.kubernetes.KubernetesServiceMXBean;
import io.hawt.util.Files;
import io.hawt.util.Function;
import io.hawt.util.IOHelper;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesService
extends MBeanSupport
implements KubernetesServiceMXBean {
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesService.class);
    private GitFacade git;

    public void init() throws Exception {
        String url = this.getKubernetesAddress();
        if (Strings.isNotBlank((String)url)) {
            super.init();
        }
    }

    public void destroy() throws Exception {
        super.destroy();
    }

    @Override
    public String getDockerIp() {
        String url = KubernetesService.resolveDockerHost();
        int idx = url.indexOf("://");
        if (idx > 0) {
            url = url.substring(idx + 3);
        }
        if ((idx = url.indexOf(":")) > 0) {
            url = url.substring(0, idx);
        }
        return url;
    }

    protected String getDefaultObjectName() {
        return "io.fabric8:type=Kubernetes";
    }

    @Override
    public String getKubernetesAddress() {
        String address = System.getenv("KUBERNETES_SERVICE_HOST");
        address = Strings.isNotBlank((String)address) ? "http://" + address + ":" + System.getenv("KUBERNETES_SERVICE_PORT") : System.getenv("KUBERNETES_MASTER");
        String username = System.getenv("KUBERNETES_USERNAME");
        String password = System.getenv("KUBERNETES_PASSWORD");
        if (Strings.isNotBlank((String)username) && Strings.isNotBlank((String)password)) {
            address = address.replaceFirst("://", "://" + username + ":" + password + "@");
        }
        return address;
    }

    @Override
    public String getHostName() {
        String answer = System.getenv("HOSTNAME");
        if (Strings.isBlank((String)answer)) {
            try {
                answer = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.warn("Could not look up local host name: " + e, (Throwable)e);
            }
        }
        return answer;
    }

    public GitFacade getGit() {
        if (this.git == null) {
            LOG.warn("No GitFacade injected! Defaulting to the singleton");
            this.git = GitFacade.getSingleton();
        }
        return this.git;
    }

    public void setGit(GitFacade git) {
        this.git = git;
    }

    @Override
    public String iconPath(String branch, final String kubernetesId) throws Exception {
        GitFacade facade = this.getGit();
        return (String)facade.readFile(branch, "/", (Function)new Function<File, String>(){

            public String apply(File rootFolder) {
                return KubernetesService.this.doFindIconPath(rootFolder, kubernetesId);
            }
        });
    }

    protected String doFindIconPath(File rootFolder, String kubernetesId) {
        File[] files;
        File appFolder = this.findAppFolder(rootFolder, kubernetesId);
        if (appFolder != null && (files = appFolder.listFiles()) != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith("icon.") || !name.endsWith(".svg") && !name.endsWith(".png") && !name.endsWith(".gif") && !name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".pdf")) continue;
                try {
                    return Files.getRelativePath((File)rootFolder, (File)file);
                }
                catch (IOException e) {
                    LOG.warn("failed to get relative folder of " + file.getAbsolutePath() + ". " + e, (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected File findAppFolder(File fileOrDirectory, String kubernetesId) {
        Pattern pattern = KubernetesService.createKubernetesIdPattern(kubernetesId);
        return this.findAppFolder(fileOrDirectory, pattern);
    }

    public static Pattern createKubernetesIdPattern(String kubernetesId) {
        String regex = "\"id\"\\s*:\\s*\"" + kubernetesId + "\"";
        Pattern answer = Pattern.compile(regex);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding kubernetes id via regex " + answer);
        }
        return answer;
    }

    protected File findAppFolder(File fileOrDirectory, Pattern pattern) {
        if (fileOrDirectory != null && fileOrDirectory.exists()) {
            File[] files;
            if (fileOrDirectory.isFile()) {
                String name = fileOrDirectory.getName();
                if (name.equals("kubernetes.json") && KubernetesService.fileTextMatchesPattern(fileOrDirectory, pattern)) {
                    return fileOrDirectory.getParentFile();
                }
            } else if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
                for (File file : files) {
                    File answer = this.findAppFolder(file, pattern);
                    if (answer == null) continue;
                    return answer;
                }
            }
        }
        return null;
    }

    public static boolean fileTextMatchesPattern(File file, Pattern pattern) {
        try {
            String text = IOHelper.readFully((File)file);
            return pattern.matcher(text).find();
        }
        catch (IOException e) {
            LOG.warn("Could not load file " + file.getAbsolutePath() + ". " + e, (Throwable)e);
            return false;
        }
    }

    public static String resolveHttpDockerHost() {
        String dockerHost = KubernetesService.resolveDockerHost();
        if (dockerHost.startsWith("tcp:")) {
            return "http:" + dockerHost.substring(4);
        }
        return dockerHost;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (Strings.isBlank((String)dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (!Strings.isBlank((String)dockerHost)) {
            return dockerHost;
        }
        return DEFAULT_DOCKER_HOST;
    }
}

