/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.dev;

import io.hawt.web.dev.DevServlet;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;

public class DevServletFactory {
    private static final Logger LOG = Logger.getLogger(DevServletFactory.class);
    private WebContainer webContainer;
    private HttpContext httpContext;
    private DevServlet servlet = new DevServlet();

    public DevServletFactory() {
        LOG.info((Object)("DevServletFactory " + this + " instantiated"));
    }

    public void init() {
        LOG.info((Object)("DevServletFactory " + this + " initialized"));
    }

    public void destroy() {
        LOG.info((Object)("DevServletFactory " + this + " destroyed"));
        try {
            this.webContainer.unregisterServlet((Servlet)this.servlet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getContext() {
        return this.servlet.getContext();
    }

    public void setContext(String context) {
        this.servlet.setContext(context);
        try {
            LOG.info((Object)("registering servlet at context : " + context));
            this.webContainer.registerServlet((Servlet)this.servlet, new String[]{context}, null, this.httpContext);
            LOG.info((Object)"registration succeeded");
        }
        catch (Exception retry) {
            try {
                LOG.info((Object)"servlet probably already registered, re-registering");
                this.webContainer.unregisterServlet((Servlet)this.servlet);
                this.webContainer.registerServlet((Servlet)this.servlet, new String[]{context}, null, this.httpContext);
            }
            catch (Exception e) {
                LOG.warn((Object)"registration failed", (Throwable)e);
            }
        }
    }

    public String getContent() {
        return this.servlet.getContentDirectory();
    }

    public void setContent(String content) {
        LOG.info((Object)("Using content directory : " + content));
        this.servlet.setContentDirectory(content);
    }

    public void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.httpContext = webContainer.getDefaultSharedHttpContext();
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }
}

