/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.dev;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DevServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final Logger LOG = Logger.getLogger(DevServlet.class);
    private String contentDirectory = null;
    private String context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requested = req.getPathInfo();
        LOG.debug((Object)("Requested file : " + requested));
        if (requested == null) {
            LOG.debug((Object)"Requested path is null");
            resp.setContentType("text/html");
            resp.sendRedirect(this.getContext().replace("/*", "") + "/index.html");
            return;
        }
        FileInputStream in = null;
        String type = null;
        File file = new File(this.contentDirectory, URLDecoder.decode(requested, "UTF-8"));
        if (file.isDirectory()) {
            LOG.debug((Object)"Requested path is a directory");
            resp.setContentType("text/html");
            resp.sendRedirect(this.getContext().replace("/*", "") + requested + "/index.html");
            return;
        }
        if (!file.exists()) {
            LOG.debug((Object)("File " + file.getPath() + " does not exist"));
            resp.sendError(404);
            return;
        }
        in = new FileInputStream(file);
        type = this.getServletContext().getMimeType(file.getAbsolutePath());
        if (type == null) {
            type = "application/octet-stream";
        }
        LOG.debug((Object)("Serving file: " + file.getAbsolutePath() + " of type " + type));
        resp.reset();
        resp.setBufferSize(10240);
        resp.setContentType(type);
        resp.setHeader("Content-Length", String.valueOf(((InputStream)in).available()));
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(in, 10240);
            output = new BufferedOutputStream((OutputStream)resp.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            DevServlet.close(output);
            DevServlet.close(input);
            DevServlet.close(in);
            throw throwable;
        }
        DevServlet.close(output);
        DevServlet.close(input);
        DevServlet.close(in);
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Error closing stream : " + e.getLocalizedMessage()));
            }
        }
    }

    public void setContentDirectory(String contentDirectory) {
        this.contentDirectory = contentDirectory;
    }

    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }
}

