/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.AboutMBean;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class About
implements AboutMBean {
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private String hawtioVersion;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null && this.objectName != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=About");
    }

    public String getHawtioVersion() {
        return this.doGetHawtioVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String doGetHawtioVersion() {
        Package aPackage;
        if (this.hawtioVersion != null) {
            return this.hawtioVersion;
        }
        InputStream is = null;
        try {
            Properties p = new Properties();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF");
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/maven/io.hawt/hawtio-web/pom.properties");
            }
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/META-INF/maven/io.hawt/hawtio-default/pom.properties");
            }
            if (is != null) {
                p.load(is);
                this.hawtioVersion = p.getProperty("Bundle-Version", null);
                if (this.hawtioVersion == null) {
                    this.hawtioVersion = p.getProperty("version", "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        if (this.hawtioVersion == null && (aPackage = Thread.currentThread().getContextClassLoader().getClass().getPackage()) != null) {
            this.hawtioVersion = aPackage.getImplementationVersion();
            if (this.hawtioVersion == null) {
                this.hawtioVersion = aPackage.getSpecificationVersion();
            }
        }
        if (this.hawtioVersion == null) {
            this.hawtioVersion = "";
        }
        return this.hawtioVersion;
    }
}

