/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.JmxTreeWatcherMBean;
import io.hawt.util.Objects;
import io.hawt.util.Strings;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTreeWatcher
implements JmxTreeWatcherMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmxTreeWatcher.class);
    private static AtomicBoolean logged = new AtomicBoolean();
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private AtomicLong counter = new AtomicLong(0L);
    private NotificationListener listener;
    private NotificationFilter filter;
    private String version;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            Object handback = null;
            this.listener = this.getNotificationListener();
            this.filter = this.getNotificationFilter();
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener, this.filter, handback);
        }
        if (logged.compareAndSet(false, true)) {
            String text = this.getVersion();
            if (Strings.isNotBlank((String)text)) {
                text = text + " ";
            }
            LOG.info("Welcome to hawtio " + text + ": http://hawt.io/ : Don't cha wish your console was hawt like me? ;-)");
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null) {
            if (this.listener != null) {
                this.mBeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.listener);
            }
            if (this.objectName != null) {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = Objects.getVersion(this.getClass(), (String)"io.hawt", (String)"hawtio-web");
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=TreeWatcher");
    }

    protected NotificationListener getNotificationListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected NotificationFilter getNotificationFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public long getCounter() {
        return this.counter.get();
    }

    static /* synthetic */ AtomicLong access$000(JmxTreeWatcher x0) {
        return x0.counter;
    }
}

