/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.QuartzFacadeMBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class QuartzFacade
implements QuartzFacadeMBean {
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null && this.objectName != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=QuartzFacade");
    }

    public void updateSimpleTrigger(String schedulerObjectName, String triggerName, String groupName, int misfireInstruction, int repeatCount, long repeatInterval) throws Exception {
        if (schedulerObjectName == null) {
            throw new IllegalArgumentException("Cannot find quartz scheduler with ObjectName: " + schedulerObjectName);
        }
        ObjectName on = ObjectName.getInstance(schedulerObjectName);
        if (!this.mBeanServer.isRegistered(on)) {
            throw new IllegalArgumentException("Cannot find quartz scheduler with ObjectName: " + schedulerObjectName);
        }
        CompositeData data = (CompositeData)this.mBeanServer.invoke(on, "getJobDetail", new Object[]{triggerName, groupName}, new String[]{"java.lang.String", "java.lang.String"});
        if (data == null) {
            throw new IllegalArgumentException("Cannot find job details for group: " + groupName + " name: " + triggerName);
        }
        HashMap jobParams = new HashMap();
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>();
        this.initJobParams(jobParams, jobDataMap, triggerName, groupName, data);
        HashMap<String, Object> triggerParams = new HashMap<String, Object>();
        jobDataMap.put("CamelQuartzTriggerType", "simple");
        triggerParams.put("repeatCount", repeatCount);
        jobDataMap.put("CamelQuartzTriggerSimpleRepeatCounter", repeatCount);
        triggerParams.put("repeatInterval", repeatInterval);
        jobDataMap.put("CamelQuartzTriggerSimpleRepeatInterval", repeatInterval);
        triggerParams.put("name", triggerName);
        triggerParams.put("group", groupName);
        triggerParams.put("jobName", triggerName);
        triggerParams.put("jobGroup", groupName);
        triggerParams.put("misfireInstruction", misfireInstruction);
        this.mBeanServer.invoke(on, "scheduleBasicJob", new Object[]{jobParams, triggerParams}, new String[]{"java.util.Map", "java.util.Map"});
    }

    public void updateCronTrigger(String schedulerObjectName, String triggerName, String groupName, int misfireInstruction, String cronExpression, String timeZone) throws Exception {
        if (schedulerObjectName == null) {
            throw new IllegalArgumentException("Cannot find quartz scheduler with ObjectName: " + schedulerObjectName);
        }
        ObjectName on = ObjectName.getInstance(schedulerObjectName);
        if (!this.mBeanServer.isRegistered(on)) {
            throw new IllegalArgumentException("Cannot find quartz scheduler with ObjectName: " + schedulerObjectName);
        }
        CompositeData data = (CompositeData)this.mBeanServer.invoke(on, "getJobDetail", new Object[]{triggerName, groupName}, new String[]{"java.lang.String", "java.lang.String"});
        if (data == null) {
            throw new IllegalArgumentException("Cannot find job details for group: " + groupName + " name: " + triggerName);
        }
        HashMap jobParams = new HashMap();
        HashMap<String, String> jobDataMap = new HashMap<String, String>();
        this.initJobParams(jobParams, jobDataMap, triggerName, groupName, data);
        HashMap<String, Object> triggerParams = new HashMap<String, Object>();
        jobDataMap.put("CamelQuartzTriggerType", "cron");
        triggerParams.put("cronExpression", cronExpression);
        jobDataMap.put("CamelQuartzTriggerCronExpression", cronExpression);
        if (timeZone != null) {
            triggerParams.put("timeZone", timeZone);
            jobDataMap.put("CamelQuartzTriggerCronTimeZone", timeZone);
        }
        triggerParams.put("name", triggerName);
        triggerParams.put("group", groupName);
        triggerParams.put("jobName", triggerName);
        triggerParams.put("jobGroup", groupName);
        triggerParams.put("misfireInstruction", misfireInstruction);
        this.mBeanServer.invoke(on, "scheduleBasicJob", new Object[]{jobParams, triggerParams}, new String[]{"java.util.Map", "java.util.Map"});
    }

    private void initJobParams(Map jobParams, Map jobDataMap, String triggerName, String groupName, CompositeData data) {
        jobParams.put("name", triggerName);
        jobParams.put("group", groupName);
        if (data.get("description") != null) {
            jobParams.put("description", data.get("description"));
        }
        jobParams.put("jobClass", data.get("jobClass"));
        jobParams.put("durability", data.get("durability"));
        jobParams.put("shouldRecover", data.get("shouldRecover"));
        TabularData tJobDataMap = (TabularData)data.get("jobDataMap");
        for (Object cKey : tJobDataMap.keySet()) {
            Object key = ((List)cKey).get(0);
            CompositeData value = tJobDataMap.get(new Object[]{key});
            if (value == null) continue;
            CompositeData cd = value;
            Iterator<?> it = cd.values().iterator();
            Object tKey = it.next();
            Object tValue = it.next();
            jobDataMap.put(tKey, tValue);
        }
        jobParams.put("jobDataMap", jobDataMap);
    }
}

