/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AuthInfo;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.system.ExtractAuthInfoCallback;
import io.hawt.system.PrivilegedCallback;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Authenticator {
    private static final transient Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTHENTICATION_SCHEME_BASIC = "Basic";

    public static void extractAuthInfo(String authHeader, ExtractAuthInfoCallback cb) {
        String[] parts = (authHeader = authHeader.trim()).split(" ");
        if (parts.length != 2) {
            return;
        }
        String authType = parts[0];
        String authInfo = parts[1];
        if (authType.equalsIgnoreCase("Basic")) {
            String decoded = new String(Base64.decodeBase64((String)authInfo));
            parts = decoded.split(":");
            if (parts.length != 2) {
                return;
            }
            String user = parts[0];
            String password = parts[1];
            cb.getAuthInfo(user, password);
        }
    }

    public static AuthenticateResult authenticate(String realm, String role, String rolePrincipalClasses, Configuration configuration, HttpServletRequest request, PrivilegedCallback cb) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.equals("")) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        AuthInfo info = new AuthInfo();
        Authenticator.extractAuthInfo((String)authHeader, (ExtractAuthInfoCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (info.username == null || info.username.equals("public")) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        if (info.set()) {
            Subject subject = Authenticator.doAuthenticate((String)realm, (String)role, (String)rolePrincipalClasses, (Configuration)configuration, (String)info.username, (String)info.password);
            if (subject == null) {
                return AuthenticateResult.NOT_AUTHORIZED;
            }
            if (cb != null) {
                try {
                    cb.execute(subject);
                }
                catch (Exception e) {
                    LOG.warn("Failed to execute privileged action: ", (Throwable)e);
                }
            }
            return AuthenticateResult.AUTHORIZED;
        }
        return AuthenticateResult.NO_CREDENTIALS;
    }

    private static Subject doAuthenticate(String realm, String role, String rolePrincipalClasses, Configuration configuration, String username, String password) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doAuthenticate[realm={}, role={}, rolePrincipalClasses={}, configuration={}, username={}, password={}]", new Object[]{realm, role, rolePrincipalClasses, configuration, username, "******"});
            }
            Subject subject = new Subject();
            AuthenticationCallbackHandler handler = new AuthenticationCallbackHandler(username, password, null);
            LoginContext loginContext = configuration != null ? new LoginContext(realm, subject, (CallbackHandler)handler, configuration) : new LoginContext(realm, subject, (CallbackHandler)handler);
            loginContext.login();
            if (role != null && role.length() > 0 && rolePrincipalClasses != null && rolePrincipalClasses.length() > 0) {
                String[] rolePrincipalClazzes = rolePrincipalClasses.split(",");
                boolean found = false;
                for (String clazz : rolePrincipalClazzes) {
                    String name = role;
                    int idx = role.indexOf(58);
                    if (idx > 0) {
                        clazz = role.substring(0, idx);
                        name = role.substring(idx + 1);
                    }
                    for (Principal p : subject.getPrincipals()) {
                        if (!p.getClass().getName().equals(clazz.trim()) || !p.getName().equals(name)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) {
                    LOG.debug("User does not have the required role " + role);
                    return null;
                }
            }
            return subject;
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
        }
        catch (LoginException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Login failed due " + e.getMessage(), (Throwable)e);
            }
            LOG.debug("Login failed due " + e.getMessage());
        }
        return null;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

