/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.web.AuthenticationFilter;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";

    public static void doForbidden(HttpServletResponse response) {
        try {
            response.setStatus(403);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send forbidden response: {}", (Throwable)ioe);
        }
    }

    public static void doAuthPrompt(String realm, HttpServletResponse response) {
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send auth response: {}", (Throwable)ioe);
        }
    }
}

