/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.ConfigManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrandingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(BrandingServlet.class);
    List<String> propertiesToCheck = new ArrayList();
    List<String> wantedStrings = new ArrayList();
    boolean forceBranding = false;
    boolean useBranding = true;
    String profile;
    Converters converters = new Converters();
    JsonConvertOptions options = JsonConvertOptions.DEFAULT;

    public void init(ServletConfig servletConfig) throws ServletException {
        ConfigManager config = (ConfigManager)servletConfig.getServletContext().getAttribute("ConfigManager");
        if (config != null) {
            String propertiesToCheckString = config.get("propertiesToCheck", "karaf.version");
            String wantedStringsString = config.get("wantedStrings", "redhat,fuse");
            this.forceBranding = Boolean.parseBoolean(config.get("forceBranding", "false"));
            this.useBranding = Boolean.parseBoolean(config.get("useBranding", "true"));
            if (propertiesToCheckString != null) {
                for (String str : propertiesToCheckString.split(",")) {
                    this.propertiesToCheck.add(str.trim());
                }
            }
            if (wantedStringsString != null) {
                for (String str : wantedStringsString.split(",")) {
                    this.wantedStrings.add(str.trim());
                }
            }
        }
        this.profile = System.getProperty("profile");
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> answer = new HashMap<String, String>();
        answer.put("profile", this.profile);
        answer.put("enable", this.enableBranding().toString());
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        Object result = null;
        try {
            result = this.converters.getToJsonConverter().convertToJson(answer, null, this.options);
        }
        catch (AttributeNotFoundException e) {
            LOG.warn("Failed to convert plugin list to json", (Throwable)e);
        }
        if (result != null) {
            out.write(result.toString());
            out.flush();
            out.close();
        } else {
            out.write("{ \"enable\":\"false\"}");
        }
    }

    private Boolean enableBranding() {
        if (this.forceBranding) {
            return true;
        }
        if (!this.useBranding) {
            return false;
        }
        Properties systemProperties = System.getProperties();
        ArrayList<String> hits = new ArrayList<String>();
        for (String property : this.propertiesToCheck) {
            if (!systemProperties.containsKey(property)) continue;
            hits.add(property);
        }
        for (String property : hits) {
            String value = systemProperties.getProperty(property);
            if (value == null) continue;
            for (String wanted : this.wantedStrings) {
                if (!value.contains(wanted)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeTrue(PrintWriter out) {
        this.writeValue(out, true);
    }

    private void writeFalse(PrintWriter out) {
        this.writeValue(out, false);
    }

    private void writeValue(PrintWriter out, boolean value) {
        out.write(Boolean.valueOf(value).toString());
        out.flush();
        out.close();
    }
}

