/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.system.ConfigManager;
import io.hawt.system.Helpers;
import io.hawt.web.ServletHelpers;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(LoginServlet.class);
    Converters converters = new Converters();
    JsonConvertOptions options = JsonConvertOptions.DEFAULT;
    ConfigManager config;
    private Integer timeout;

    public void init(ServletConfig servletConfig) throws ServletException {
        String s;
        this.config = (ConfigManager)servletConfig.getServletContext().getAttribute("ConfigManager");
        if (this.config != null && (s = this.config.get("sessionTimeout", null)) != null) {
            try {
                this.timeout = Integer.parseInt(s);
                if (this.timeout == 0) {
                    this.timeout = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.info("hawtio login is using " + (this.timeout != null ? this.timeout + " sec." : "default") + " HttpSession timeout");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        PrintWriter out = resp.getWriter();
        HttpSession session = req.getSession(false);
        if (session != null) {
            Subject subject = (Subject)session.getAttribute("subject");
            if (subject == null) {
                LOG.warn("No security subject stored in existing session, invalidating");
                session.invalidate();
                Helpers.doForbidden((HttpServletResponse)resp);
            }
            this.returnPrincipals(subject, out);
            return;
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            Helpers.doForbidden((HttpServletResponse)resp);
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        String username = null;
        if (principals != null) {
            for (Principal principal : principals) {
                if (!principal.getClass().getSimpleName().equals("UserPrincipal")) continue;
                username = principal.getName();
                LOG.debug("Authorizing user {}", (Object)username);
            }
        }
        session = req.getSession(true);
        session.setAttribute("subject", (Object)subject);
        session.setAttribute("user", username);
        session.setAttribute("org.osgi.service.http.authentication.remote.user", username);
        session.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
        session.setAttribute("loginTime", (Object)GregorianCalendar.getInstance().getTimeInMillis());
        if (this.timeout != null) {
            session.setMaxInactiveInterval(this.timeout.intValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Http session timeout for user {} is {} sec.", (Object)username, (Object)session.getMaxInactiveInterval());
        }
        this.returnPrincipals(subject, out);
    }

    private void returnPrincipals(Subject subject, PrintWriter out) {
        HashMap answer = new HashMap();
        ArrayList principals = new ArrayList();
        for (Principal principal : subject.getPrincipals()) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("type", principal.getClass().getName());
            data.put("name", principal.getName());
            principals.add(data);
        }
        ArrayList credentials = new ArrayList();
        for (Object credential : subject.getPublicCredentials()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("type", credential.getClass().getName());
            data.put("credential", credential);
        }
        answer.put("principals", principals);
        answer.put("credentials", credentials);
        ServletHelpers.writeObject((Converters)this.converters, (JsonConvertOptions)this.options, (PrintWriter)out, answer);
    }
}

