/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.IOHelper;
import io.hawt.web.OpenShiftProtocolSocketFactory;
import io.hawt.web.ProxyDetails;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String STRING_LOCATION_HEADER = "Location";
    private static final String STRING_CONTENT_TYPE_HEADER_NAME = "Content-Type";
    private static final String STRING_CONTENT_LENGTH_HEADER_NAME = "Content-Length";
    private static final String[] IGNORE_HEADER_NAMES = new String[]{"Content-Length", "Origin", "Authorization"};
    private static final String STRING_HOST_HEADER_NAME = "Host";
    private static final File FILE_UPLOAD_TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    private int intMaxFileUploadSize = 0x500000;

    public void init(ServletConfig servletConfig) {
        OpenShiftProtocolSocketFactory socketFactory = OpenShiftProtocolSocketFactory.getSocketFactory();
        Protocol http = new Protocol("http", (ProtocolSocketFactory)socketFactory, 80);
        Protocol.registerProtocol((String)"http", (Protocol)http);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered OpenShiftProtocolSocketFactory Protocol for http: " + Protocol.getProtocol((String)"http").getSocketFactory());
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ProxyDetails proxyDetails = new ProxyDetails(httpServletRequest);
        GetMethod getMethodProxyRequest = new GetMethod(proxyDetails.getStringProxyURL());
        this.setProxyRequestHeaders(proxyDetails, httpServletRequest, (HttpMethod)getMethodProxyRequest);
        this.executeProxyRequest(proxyDetails, (HttpMethod)getMethodProxyRequest, httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ProxyDetails proxyDetails = new ProxyDetails(httpServletRequest);
        PostMethod postMethodProxyRequest = new PostMethod(proxyDetails.getStringProxyURL());
        this.setProxyRequestHeaders(proxyDetails, httpServletRequest, (HttpMethod)postMethodProxyRequest);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
            this.handleMultipartPost(postMethodProxyRequest, httpServletRequest);
        } else {
            this.handleStandardPost(postMethodProxyRequest, httpServletRequest);
        }
        this.executeProxyRequest(proxyDetails, (HttpMethod)postMethodProxyRequest, httpServletRequest, httpServletResponse);
    }

    private void handleMultipartPost(PostMethod postMethodProxyRequest, HttpServletRequest httpServletRequest) throws ServletException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        diskFileItemFactory.setSizeThreshold(this.getMaxFileUploadSize());
        diskFileItemFactory.setRepository(FILE_UPLOAD_TEMP_DIRECTORY);
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        try {
            List listFileItems = servletFileUpload.parseRequest(httpServletRequest);
            ArrayList<Object> listParts = new ArrayList<Object>();
            for (FileItem fileItemCurrent : listFileItems) {
                if (fileItemCurrent.isFormField()) {
                    StringPart stringPart = new StringPart(fileItemCurrent.getFieldName(), fileItemCurrent.getString());
                    listParts.add(stringPart);
                    continue;
                }
                FilePart filePart = new FilePart(fileItemCurrent.getFieldName(), (PartSource)new ByteArrayPartSource(fileItemCurrent.getName(), fileItemCurrent.get()));
                listParts.add(filePart);
            }
            MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(listParts.toArray(new Part[0]), postMethodProxyRequest.getParams());
            postMethodProxyRequest.setRequestEntity((RequestEntity)multipartRequestEntity);
            postMethodProxyRequest.setRequestHeader(STRING_CONTENT_TYPE_HEADER_NAME, multipartRequestEntity.getContentType());
        }
        catch (FileUploadException fileUploadException) {
            throw new ServletException((Throwable)fileUploadException);
        }
    }

    private void handleStandardPost(PostMethod postMethodProxyRequest, HttpServletRequest httpServletRequest) throws IOException {
        Map mapPostParameters = httpServletRequest.getParameterMap();
        ArrayList<NameValuePair> listNameValuePairs = new ArrayList<NameValuePair>();
        for (String stringParameterName : mapPostParameters.keySet()) {
            String[] stringArrayParameterValues;
            for (String stringParamterValue : stringArrayParameterValues = (String[])mapPostParameters.get(stringParameterName)) {
                NameValuePair nameValuePair = new NameValuePair(stringParameterName, stringParamterValue);
                listNameValuePairs.add(nameValuePair);
            }
        }
        StringRequestEntity entity = null;
        String contentType = httpServletRequest.getContentType();
        if (contentType != null && ((contentType = contentType.toLowerCase()).contains("json") || contentType.contains("xml") || contentType.contains("application") || contentType.contains("text"))) {
            String body = IOHelper.readFully((BufferedReader)httpServletRequest.getReader());
            entity = new StringRequestEntity(body, contentType, httpServletRequest.getCharacterEncoding());
            postMethodProxyRequest.setRequestEntity((RequestEntity)entity);
        }
        NameValuePair[] parameters = listNameValuePairs.toArray(new NameValuePair[0]);
        if (entity == null) {
            postMethodProxyRequest.setRequestBody(parameters);
        }
    }

    private void executeProxyRequest(ProxyDetails proxyDetails, HttpMethod httpMethodProxyRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int intNextByte;
        Header[] headerArrayResponse;
        httpMethodProxyRequest.setFollowRedirects(false);
        HttpClient httpClient = proxyDetails.createHttpClient(httpMethodProxyRequest);
        int intProxyResponseCode = httpClient.executeMethod(httpMethodProxyRequest);
        if (intProxyResponseCode >= 300 && intProxyResponseCode < 304) {
            String stringStatusCode = Integer.toString(intProxyResponseCode);
            String stringLocation = httpMethodProxyRequest.getResponseHeader(STRING_LOCATION_HEADER).getValue();
            if (stringLocation == null) {
                throw new ServletException("Received status code: " + stringStatusCode + " but no " + STRING_LOCATION_HEADER + " header was found in the response");
            }
            String stringMyHostName = httpServletRequest.getServerName();
            if (httpServletRequest.getServerPort() != 80) {
                stringMyHostName = stringMyHostName + ":" + httpServletRequest.getServerPort();
            }
            stringMyHostName = stringMyHostName + httpServletRequest.getContextPath();
            httpServletResponse.sendRedirect(stringLocation.replace(proxyDetails.getProxyHostAndPort() + proxyDetails.getProxyPath(), stringMyHostName));
            return;
        }
        if (intProxyResponseCode == 304) {
            httpServletResponse.setIntHeader(STRING_CONTENT_LENGTH_HEADER_NAME, 0);
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.setStatus(intProxyResponseCode);
        for (Header header : headerArrayResponse = httpMethodProxyRequest.getResponseHeaders()) {
            httpServletResponse.setHeader(header.getName(), header.getValue());
        }
        InputStream inputStreamProxyResponse = httpMethodProxyRequest.getResponseBodyAsStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStreamProxyResponse);
        ServletOutputStream outputStreamClientResponse = httpServletResponse.getOutputStream();
        while ((intNextByte = bufferedInputStream.read()) != -1) {
            outputStreamClientResponse.write(intNextByte);
        }
    }

    public String getServletInfo() {
        return "Jason's Proxy Servlet";
    }

    private void setProxyRequestHeaders(ProxyDetails proxyDetails, HttpServletRequest httpServletRequest, HttpMethod httpMethodProxyRequest) {
        Enumeration enumerationOfHeaderNames = httpServletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String stringHeaderName = (String)enumerationOfHeaderNames.nextElement();
            if (stringHeaderName.equalsIgnoreCase(STRING_CONTENT_LENGTH_HEADER_NAME) || stringHeaderName.equalsIgnoreCase("Authorization") || stringHeaderName.equalsIgnoreCase("Origin")) continue;
            Enumeration enumerationOfHeaderValues = httpServletRequest.getHeaders(stringHeaderName);
            while (enumerationOfHeaderValues.hasMoreElements()) {
                String stringHeaderValue = (String)enumerationOfHeaderValues.nextElement();
                if (stringHeaderName.equalsIgnoreCase(STRING_HOST_HEADER_NAME)) {
                    stringHeaderValue = proxyDetails.getProxyHostAndPort();
                }
                Header header = new Header(stringHeaderName, stringHeaderValue);
                httpMethodProxyRequest.setRequestHeader(header);
            }
        }
    }

    private int getMaxFileUploadSize() {
        return this.intMaxFileUploadSize;
    }

    private void setMaxFileUploadSize(int intMaxFileUploadSizeNew) {
        this.intMaxFileUploadSize = intMaxFileUploadSizeNew;
    }
}

