/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Date;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;

public class LockFile {
    private static final boolean DISABLE_FILE_LOCK = Boolean.getBoolean("java.nio.channels.FileLock.broken");
    private final File file;
    private FileLock lock;
    private RandomAccessFile readFile;
    private int lockCounter;
    private final boolean deleteOnUnlock;
    private volatile boolean locked;

    public LockFile(File file, boolean deleteOnUnlock) {
        this.file = file;
        this.deleteOnUnlock = deleteOnUnlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lock() throws IOException {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        if (this.lockCounter > 0) {
            return;
        }
        IOHelper.mkdirs(this.file.getParentFile());
        Class<LockFile> clazz = LockFile.class;
        synchronized (LockFile.class) {
            block21: {
                if (System.getProperty(this.getVmLockKey()) != null) {
                    throw new IOException("File '" + this.file + "' could not be locked as lock is already held for this jvm.");
                }
                System.setProperty(this.getVmLockKey(), new Date().toString());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    if (this.lock != null) break block21;
                    this.readFile = new RandomAccessFile(this.file, "rw");
                    IOException reason = null;
                    try {
                        this.lock = this.readFile.getChannel().tryLock(0L, Math.max(1L, this.readFile.getChannel().size()), false);
                    }
                    catch (OverlappingFileLockException e) {
                        reason = IOExceptionSupport.create((String)("File '" + this.file + "' could not be locked."), (Exception)e);
                    }
                    catch (IOException ioe) {
                        reason = ioe;
                    }
                    if (this.lock != null) {
                        ++this.lockCounter;
                        System.setProperty(this.getVmLockKey(), new Date().toString());
                        this.locked = true;
                        break block21;
                    }
                    this.closeReadFile();
                    if (reason != null) {
                        throw reason;
                    }
                    throw new IOException("File '" + this.file + "' could not be locked.");
                }
                finally {
                    clazz = LockFile.class;
                    synchronized (LockFile.class) {
                        if (this.lock == null) {
                            System.getProperties().remove(this.getVmLockKey());
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
            return;
        }
    }

    public void unlock() {
        if (DISABLE_FILE_LOCK) {
            return;
        }
        --this.lockCounter;
        if (this.lockCounter != 0) {
            return;
        }
        if (this.lock != null) {
            try {
                this.lock.release();
                System.getProperties().remove(this.getVmLockKey());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.lock = null;
        }
        this.closeReadFile();
        if (this.locked && this.deleteOnUnlock) {
            this.file.delete();
        }
    }

    private String getVmLockKey() throws IOException {
        return this.getClass().getName() + ".lock." + this.file.getCanonicalPath();
    }

    private void closeReadFile() {
        if (this.readFile != null) {
            try {
                this.readFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.readFile = null;
        }
    }

    public boolean keepAlive() {
        this.locked = this.locked && this.lock != null && this.lock.isValid() && this.file.exists();
        return this.locked;
    }
}

