/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.broker.PublishedAddressPolicy;
import org.apache.activemq.broker.TransportConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PublishedAddressPolicyTest {
    PublishedAddressPolicy underTest = new PublishedAddressPolicy();
    final AtomicReference<URI> uriAtomicReference = new AtomicReference();
    final TransportConnector dummyTransportConnector = new TransportConnector(){

        public URI getConnectUri() throws IOException, URISyntaxException {
            return PublishedAddressPolicyTest.this.uriAtomicReference.get();
        }
    };

    @Before
    public void setTransport() throws Exception {
        URI ok = new URI("tcp://bob:88");
        this.uriAtomicReference.set(ok);
    }

    @Test
    public void testDefaultReturnsHost() throws Exception {
        Assert.assertTrue((String)"contains bob", (boolean)this.underTest.getPublishableConnectString(this.dummyTransportConnector).contains("bob"));
    }

    @Test
    public void testHostMap() throws Exception {
        HashMap<String, String> hostMap = new HashMap<String, String>();
        hostMap.put("bob", "pat");
        this.underTest.setHostMapping(hostMap);
        Assert.assertTrue((String)"contains pat", (boolean)this.underTest.getPublishableConnectString(this.dummyTransportConnector).contains("pat"));
    }

    @Test
    public void testPortMap() throws Exception {
        HashMap<Integer, Integer> portMap = new HashMap<Integer, Integer>();
        portMap.put(88, 77);
        this.underTest.setPortMapping(portMap);
        Assert.assertTrue((String)"contains 77", (boolean)this.underTest.getPublishableConnectString(this.dummyTransportConnector).contains("77"));
    }
}

