/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.File;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LockFile;
import org.junit.Assert;
import org.junit.Test;

public class LockFileTest {
    @Test
    public void testNoDeleteOnUnlockIfNotLocked() throws Exception {
        File lockFile = new File(IOHelper.getDefaultDataDirectory(), "lockToTest1");
        IOHelper.mkdirs((File)lockFile.getParentFile());
        lockFile.createNewFile();
        LockFile underTest = new LockFile(lockFile, true);
        underTest.lock();
        lockFile.delete();
        Assert.assertFalse((String)"no longer valid", (boolean)underTest.keepAlive());
        lockFile.createNewFile();
        underTest.unlock();
        Assert.assertTrue((String)"file still exists after unlock when not locked", (boolean)lockFile.exists());
    }

    @Test
    public void testDeleteOnUnlockIfLocked() throws Exception {
        File lockFile = new File(IOHelper.getDefaultDataDirectory(), "lockToTest2");
        IOHelper.mkdirs((File)lockFile.getParentFile());
        lockFile.createNewFile();
        LockFile underTest = new LockFile(lockFile, true);
        underTest.lock();
        Assert.assertTrue((String)"valid", (boolean)underTest.keepAlive());
        underTest.unlock();
        Assert.assertFalse((String)"file deleted on unlock", (boolean)lockFile.exists());
    }
}

