/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.InvalidClientIDException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class LinkStealingTest
extends TestCase {
    protected BrokerService brokerService;
    protected int timeOutInSeconds = 10;

    protected void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    public void testStealLinkFails() throws Exception {
        this.brokerService.addConnector(ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL);
        this.brokerService.start();
        String clientID = "ThisIsAClientId";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL);
        Connection connection1 = factory.createConnection();
        connection1.setClientID("ThisIsAClientId");
        connection1.start();
        AtomicBoolean exceptionFlag = new AtomicBoolean();
        try {
            Connection connection2 = factory.createConnection();
            connection2.setClientID("ThisIsAClientId");
            connection2.start();
        }
        catch (InvalidClientIDException e) {
            exceptionFlag.set(true);
        }
        LinkStealingTest.assertTrue((boolean)exceptionFlag.get());
    }

    public void testStealLinkSuccess() throws Exception {
        this.brokerService.addConnector(ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL + "?allowLinkStealing=true");
        this.brokerService.start();
        String clientID = "ThisIsAClientId";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL);
        Connection connection1 = factory.createConnection();
        connection1.setClientID("ThisIsAClientId");
        connection1.start();
        AtomicBoolean exceptionFlag = new AtomicBoolean();
        try {
            Connection connection2 = factory.createConnection();
            connection2.setClientID("ThisIsAClientId");
            connection2.start();
        }
        catch (InvalidClientIDException e) {
            e.printStackTrace();
            exceptionFlag.set(true);
        }
        LinkStealingTest.assertFalse((boolean)exceptionFlag.get());
    }
}

