/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.concurrent.CountDownLatch;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerThread.class);
    int messageCount = 1000;
    int receiveTimeOut = 3000;
    Destination destination;
    Session session;
    boolean breakOnNull = true;
    int sleep;
    int transactionBatchSize;
    int received = 0;
    int transactions = 0;
    boolean running = false;
    CountDownLatch finished;

    public ConsumerThread(Session session, Destination destination) {
        this.destination = destination;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        MessageConsumer consumer = null;
        String threadName = Thread.currentThread().getName();
        LOG.info(threadName + " wait until " + this.messageCount + " messages are consumed");
        try {
            consumer = this.session.createConsumer(this.destination);
            while (this.running && this.received < this.messageCount) {
                Message msg = consumer.receive((long)this.receiveTimeOut);
                if (msg != null) {
                    LOG.info(threadName + " Received " + (msg instanceof TextMessage ? ((TextMessage)msg).getText() : msg.getJMSMessageID()));
                    ++this.received;
                } else if (this.breakOnNull) {
                    break;
                }
                if (this.transactionBatchSize > 0 && this.received > 0 && this.received % this.transactionBatchSize == 0) {
                    LOG.info(threadName + " Committing transaction: " + this.transactions++);
                    this.session.commit();
                }
                if (this.sleep <= 0) continue;
                Thread.sleep(this.sleep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (consumer != null) {
                LOG.info(threadName + " Consumed: " + this.getReceived() + " messages");
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
        LOG.info(threadName + " Consumer thread finished");
    }

    public int getReceived() {
        return this.received;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public boolean isBreakOnNull() {
        return this.breakOnNull;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public CountDownLatch getFinished() {
        return this.finished;
    }

    public void setFinished(CountDownLatch finished) {
        this.finished = finished;
    }
}

