/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerThread.class);
    int messageCount = 1000;
    Destination destination;
    protected Session session;
    int sleep = 0;
    boolean persistent = true;
    int messageSize = 0;
    int textMessageSize;
    long msgTTL = 0L;
    String msgGroupID = null;
    int transactionBatchSize;
    int transactions = 0;
    int sentCount = 0;
    byte[] payload = null;
    boolean running = false;
    CountDownLatch finished;

    public ProducerThread(Session session, Destination destination) {
        this.destination = destination;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProducer producer = null;
        String threadName = Thread.currentThread().getName();
        try {
            producer = this.session.createProducer(this.destination);
            producer.setDeliveryMode(this.persistent ? 2 : 1);
            producer.setTimeToLive(this.msgTTL);
            this.initPayLoad();
            this.running = true;
            LOG.info(threadName + " Started to calculate elapsed time ...\n");
            long tStart = System.currentTimeMillis();
            this.sentCount = 0;
            while (this.sentCount < this.messageCount && this.running) {
                Message message = this.createMessage(this.sentCount);
                producer.send(message);
                LOG.info(threadName + " Sent: " + (message instanceof TextMessage ? ((TextMessage)message).getText() : message.getJMSMessageID()));
                if (this.transactionBatchSize > 0 && this.sentCount > 0 && this.sentCount % this.transactionBatchSize == 0) {
                    LOG.info(threadName + " Committing transaction: " + this.transactions++);
                    this.session.commit();
                }
                if (this.sleep > 0) {
                    Thread.sleep(this.sleep);
                }
                ++this.sentCount;
            }
            LOG.info(threadName + " Produced: " + this.getSentCount() + " messages");
            long tEnd = System.currentTimeMillis();
            long elapsed = (tEnd - tStart) / 1000L;
            LOG.info(threadName + " Elapsed time in second : " + elapsed + " s");
            LOG.info(threadName + " Elapsed time in milli second : " + (tEnd - tStart) + " milli seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initPayLoad() {
        if (this.messageSize > 0) {
            this.payload = new byte[this.messageSize];
            for (int i = 0; i < this.payload.length; ++i) {
                this.payload[i] = 46;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message createMessage(int i) throws Exception {
        BytesMessage message = null;
        if (this.payload != null) {
            message = this.session.createBytesMessage();
            message.writeBytes(this.payload);
        } else if (this.textMessageSize > 0) {
            try (InputStreamReader reader = null;){
                InputStream is = this.getClass().getResourceAsStream("demo.txt");
                reader = new InputStreamReader(is);
                char[] chars = new char[this.textMessageSize];
                reader.read(chars);
                message = this.session.createTextMessage(String.valueOf(chars));
            }
        } else {
            message = this.session.createTextMessage("test message: " + i);
        }
        if (this.msgGroupID != null && !this.msgGroupID.isEmpty()) {
            message.setStringProperty("JMSXGroupID", this.msgGroupID);
        }
        return message;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public int getSleep() {
        return this.sleep;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public void setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public void setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public void setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public CountDownLatch getFinished() {
        return this.finished;
    }

    public void setFinished(CountDownLatch finished) {
        this.finished = finished;
    }
}

