/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.Service;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQConnectionSupport;
import org.apache.activemq.ra.ActiveMQEndpointActivationKey;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQResourceAdapter
extends ActiveMQConnectionSupport
implements Serializable,
MessageResourceAdapter {
    private static final long serialVersionUID = 360805587169336959L;
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQResourceAdapter.class);
    private final transient HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> endpointWorkers = new HashMap();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private transient BootstrapContext bootstrapContext;
    private String brokerXmlConfig;
    private transient BrokerService broker;
    private transient Thread brokerStartThread;
    private ActiveMQConnectionFactory connectionFactory;
    private transient TransactionContext xaRecoveryTransactionContext;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.log.debug("Start: " + this.getInfo());
        this.bootstrapContext = bootstrapContext;
        if (this.brokerXmlConfig != null && this.brokerXmlConfig.trim().length() > 0) {
            this.brokerStartThread = new Thread("Starting ActiveMQ Broker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ActiveMQResourceAdapter.this.log.debug("original thread context classLoader: " + Thread.currentThread().getContextClassLoader());
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        ActiveMQResourceAdapter.this.log.debug("current (from getClass()) thread context classLoader: " + Thread.currentThread().getContextClassLoader());
                        ActiveMQResourceAdapter activeMQResourceAdapter = ActiveMQResourceAdapter.this;
                        synchronized (activeMQResourceAdapter) {
                            ActiveMQResourceAdapter.this.broker = BrokerFactory.createBroker((URI)new URI(ActiveMQResourceAdapter.this.brokerXmlConfig));
                        }
                        ActiveMQResourceAdapter.this.broker.start();
                        if (ActiveMQResourceAdapter.this.getServerUrl() == null) {
                            ActiveMQResourceAdapter.this.setServerUrl("vm://" + ActiveMQResourceAdapter.this.broker.getBrokerName() + "?create=false");
                        }
                    }
                    catch (Throwable e) {
                        ActiveMQResourceAdapter.this.log.warn("Could not start up embeded ActiveMQ Broker '" + ActiveMQResourceAdapter.this.brokerXmlConfig + "': " + e.getMessage());
                        ActiveMQResourceAdapter.this.log.debug("Reason for: " + e.getMessage(), e);
                    }
                }
            };
            this.brokerStartThread.setDaemon(true);
            this.brokerStartThread.start();
            try {
                this.brokerStartThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.started.compareAndSet(false, true);
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        if (this.connectionFactory == null) {
            return this.makeConnection(this.getInfo());
        }
        return this.makeConnection(this.getInfo(), this.connectionFactory);
    }

    @Override
    public ActiveMQConnection makeConnection(MessageActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory cf = this.getConnectionFactory();
        if (cf == null) {
            cf = this.createConnectionFactory(this.getInfo(), activationSpec);
        }
        String userName = this.defaultValue(activationSpec.getUserName(), this.getInfo().getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.getInfo().getPassword());
        String clientId = activationSpec.getClientId();
        if (clientId != null) {
            cf.setClientID(clientId);
        } else if (activationSpec.isDurableSubscription()) {
            this.log.warn("No clientID specified for durable subscription: " + activationSpec);
        }
        ActiveMQConnection physicalConnection = (ActiveMQConnection)cf.createConnection(userName, password);
        RedeliveryPolicy redeliveryPolicy = activationSpec.redeliveryPolicy();
        if (redeliveryPolicy != null) {
            physicalConnection.setRedeliveryPolicy(redeliveryPolicy);
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.log.debug("Stop: " + this.getInfo());
        this.started.compareAndSet(true, false);
        Serializable serializable = this.endpointWorkers;
        synchronized (serializable) {
            while (this.endpointWorkers.size() > 0) {
                ActiveMQEndpointActivationKey key = this.endpointWorkers.keySet().iterator().next();
                this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
            }
        }
        serializable = this;
        synchronized (serializable) {
            if (this.broker != null) {
                if (this.brokerStartThread.isAlive()) {
                    this.brokerStartThread.interrupt();
                }
                ServiceSupport.dispose((Service)this.broker);
                this.broker = null;
            }
            if (this.xaRecoveryTransactionContext != null) {
                try {
                    this.xaRecoveryTransactionContext.getConnection().close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.bootstrapContext = null;
        this.xaRecoveryTransactionContext = null;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        if (!this.equals(activationSpec.getResourceAdapter())) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance (" + activationSpec.getResourceAdapter() + " != " + this + ")");
        }
        if (!(activationSpec instanceof MessageActivationSpec)) {
            throw new NotSupportedException("That type of ActivationSpec not supported: " + activationSpec.getClass());
        }
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        ActiveMQEndpointWorker worker = new ActiveMQEndpointWorker(this, key);
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec instanceof MessageActivationSpec) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
            ActiveMQEndpointWorker worker = null;
            HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> hashMap = this.endpointWorkers;
            synchronized (hashMap) {
                worker = this.endpointWorkers.remove(key);
            }
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        LOG.debug("getXAResources: activationSpecs" + (activationSpecs != null ? Arrays.asList(activationSpecs) : "[]") + ", info: " + this.getInfo());
        if (!this.started.get()) {
            LOG.debug("RAR[" + this.getInfo() + "] stopped or undeployed; no connection available for xa recovery");
            return new XAResource[0];
        }
        try {
            ActiveMQResourceAdapter activeMQResourceAdapter = this;
            synchronized (activeMQResourceAdapter) {
                if (this.xaRecoveryTransactionContext == null) {
                    LOG.debug("Init XAResource with: " + this.getInfo());
                    this.xaRecoveryTransactionContext = new TransactionContext(this.makeConnection());
                }
            }
            return new XAResource[]{this.xaRecoveryTransactionContext};
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageResourceAdapter)) {
            return false;
        }
        MessageResourceAdapter activeMQResourceAdapter = (MessageResourceAdapter)o;
        if (!this.getInfo().equals(activeMQResourceAdapter.getInfo())) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.getBrokerXmlConfig());
    }

    public int hashCode() {
        int result = this.getInfo().hashCode();
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory aConnectionFactory) {
        this.connectionFactory = aConnectionFactory;
    }
}

