/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6000Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6000Test.class);
    private BrokerService brokerService;
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.addConnector("nio://0.0.0.0:0?wireFormat.maxInactivityDurationInitalDelay=1000&wireFormat.maxInactivityDuration=300");
        this.brokerService.start();
        this.connectionUri = this.brokerService.getTransportConnectorByScheme("nio").getPublishableConnectString();
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Test
    public void testReadCounter() throws Exception {
        LOG.info("Connecting to: {}", (Object)this.connectionUri);
        byte[] payload = new byte[0x3200000];
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri + "?useInactivityMonitor=false");
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.start();
        LOG.info("Connected to: {}", (Object)connection.getTransport());
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test");
        MessageProducer producer = session.createProducer((Destination)queue);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(payload);
        producer.setDeliveryMode(2);
        producer.send((Message)message);
        connection.close();
    }
}

