/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.console.CommandContext;
import org.apache.activemq.console.command.AmqBrowseCommand;
import org.apache.activemq.console.command.DummyConnectionFactory;
import org.apache.activemq.console.command.InvalidConnectionFactory;
import org.apache.activemq.console.command.PurgeCommandTest;
import org.apache.activemq.console.formatter.CommandShellOutputFormatter;
import org.apache.activemq.console.formatter.OutputFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AMQ3410Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeCommandTest.class);
    private static final Collection<String> DEFAULT_OPTIONS = Arrays.asList("--amqurl", "tcp://localhost:61616");
    private static final Collection<String> DEFAULT_TOKENS = Arrays.asList("FOO.QUEUE");
    protected AbstractApplicationContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = this.createApplicationContext();
    }

    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/console/command/activemq.xml");
    }

    protected void tearDown() throws Exception {
        BrokerService broker = (BrokerService)this.context.getBean("localbroker");
        broker.stop();
        broker = (BrokerService)this.context.getBean("default");
        broker.stop();
        super.tearDown();
    }

    public void testNoFactorySet() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.addAll(DEFAULT_TOKENS);
        command.execute(tokens);
        AMQ3410Test.assertNotNull((Object)command.getConnectionFactory());
        AMQ3410Test.assertTrue((boolean)(command.getConnectionFactory() instanceof ActiveMQConnectionFactory));
    }

    public void testFactorySet() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--factory");
        tokens.add(DummyConnectionFactory.class.getCanonicalName());
        tokens.addAll(DEFAULT_TOKENS);
        command.execute(tokens);
        AMQ3410Test.assertNotNull((Object)command.getConnectionFactory());
        AMQ3410Test.assertTrue((String)("wrong instance returned: " + command.getConnectionFactory().getClass().getName()), (boolean)(command.getConnectionFactory() instanceof DummyConnectionFactory));
    }

    public void testFactorySetWrong1() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--factory");
        tokens.add("org.apache.activemq.console.command.TestAMQ3410.DoesntExistFactory");
        tokens.addAll(DEFAULT_TOKENS);
        try {
            command.execute(tokens);
        }
        catch (Throwable cause) {
            while (null != cause) {
                if (cause instanceof ClassNotFoundException) {
                    return;
                }
                cause = cause.getCause();
            }
        }
        AMQ3410Test.assertFalse((String)"No exception caught", (boolean)true);
    }

    public void testFactorySetWrong2() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--factory");
        tokens.add(InvalidConnectionFactory.class.getCanonicalName());
        tokens.addAll(DEFAULT_TOKENS);
        try {
            command.execute(tokens);
        }
        catch (Throwable e) {
            for (Throwable cause = e; null != cause; cause = cause.getCause()) {
                if (!(cause instanceof NoSuchMethodException)) continue;
                return;
            }
            AMQ3410Test.assertFalse((String)e.toString(), (boolean)true);
        }
        AMQ3410Test.assertFalse((String)"No exception caught", (boolean)true);
    }

    public void testFactorySetWrong3() throws Exception {
        AmqBrowseCommand command = new AmqBrowseCommand();
        CommandContext context = new CommandContext();
        context.setFormatter((OutputFormatter)new CommandShellOutputFormatter((OutputStream)System.out));
        command.setCommandContext(context);
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.addAll(DEFAULT_OPTIONS);
        tokens.add("--factory");
        tokens.add("java.lang.Object");
        tokens.addAll(DEFAULT_TOKENS);
        try {
            command.execute(tokens);
        }
        catch (Throwable cause) {
            while (null != cause) {
                if (cause instanceof NoSuchMethodException) {
                    return;
                }
                cause = cause.getCause();
            }
        }
        AMQ3410Test.assertFalse((boolean)true);
    }
}

