/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactorySupport;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.simple.SimpleDiscoveryAgent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3014Test {
    private static final String BROKER_URL = "tcp://localhost:0";
    private List<BrokerInfo> remoteBrokerInfos = Collections.synchronizedList(new ArrayList());
    private BrokerService localBroker = new BrokerService();
    private BrokerService remoteBroker = new BrokerService(){

        protected TransportConnector createTransportConnector(URI brokerURI) throws Exception {
            TransportServer transport = TransportFactorySupport.bind((BrokerService)this, (URI)brokerURI);
            return new TransportConnector(transport){

                protected Connection createConnection(Transport transport) throws IOException {
                    Connection connection = super.createConnection(transport);
                    final TransportListener proxiedListener = transport.getTransportListener();
                    transport.setTransportListener(new TransportListener(){

                        public void onCommand(Object command) {
                            if (command instanceof BrokerInfo) {
                                AMQ3014Test.this.remoteBrokerInfos.add((BrokerInfo)command);
                            }
                            proxiedListener.onCommand(command);
                        }

                        public void onException(IOException error) {
                            proxiedListener.onException(error);
                        }

                        public void transportInterupted() {
                            proxiedListener.transportInterupted();
                        }

                        public void transportResumed() {
                            proxiedListener.transportResumed();
                        }
                    });
                    return connection;
                }
            };
        }
    };

    @Before
    public void init() throws Exception {
        this.localBroker.setBrokerName("localBroker");
        this.localBroker.setPersistent(false);
        this.localBroker.setUseJmx(false);
        this.localBroker.setSchedulerSupport(false);
        this.remoteBroker.setBrokerName("remoteBroker");
        this.remoteBroker.setPersistent(false);
        this.remoteBroker.setUseJmx(false);
        this.remoteBroker.addConnector(BROKER_URL);
        this.remoteBroker.setSchedulerSupport(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void cleanup() throws Exception {
        try {
            this.localBroker.stop();
        }
        finally {
            this.remoteBroker.stop();
        }
    }

    @Test
    public void NormalCaseTest() throws Exception {
        this.runTest(0L, 3000L);
    }

    @Test
    public void DelayedCaseTest() throws Exception {
        this.runTest(500L, 3000L);
    }

    private void runTest(final long taskRunnerDelay, long timeout) throws Exception {
        DiscoveryNetworkConnector dnc = new DiscoveryNetworkConnector();
        SimpleDiscoveryAgent da = new SimpleDiscoveryAgent();
        da.setServices(((TransportConnector)this.remoteBroker.getTransportConnectors().get(0)).getPublishableConnectString());
        dnc.setDiscoveryAgent((DiscoveryAgent)da);
        this.localBroker.addNetworkConnector((NetworkConnector)dnc);
        final TaskRunnerFactory realTaskRunnerFactory = this.localBroker.getTaskRunnerFactory();
        this.localBroker.setTaskRunnerFactory(new TaskRunnerFactory(){

            public TaskRunner createTaskRunner(Task task, String name) {
                final TaskRunner realTaskRunner = realTaskRunnerFactory.createTaskRunner(task, name);
                if (name.startsWith("ActiveMQ Connection Dispatcher: ")) {
                    return new TaskRunner(){

                        public void shutdown() throws InterruptedException {
                            realTaskRunner.shutdown();
                        }

                        public void shutdown(long timeout) throws InterruptedException {
                            realTaskRunner.shutdown(timeout);
                        }

                        public void wakeup() throws InterruptedException {
                            Thread.sleep(taskRunnerDelay);
                            realTaskRunner.wakeup();
                        }
                    };
                }
                return realTaskRunnerFactory.createTaskRunner(task, name);
            }
        });
        this.remoteBroker.start();
        this.localBroker.start();
        long startTimeMillis = System.currentTimeMillis();
        while (this.remoteBrokerInfos.isEmpty() && System.currentTimeMillis() - startTimeMillis < timeout) {
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Timed out waiting for bridge to form.", (boolean)this.remoteBrokerInfos.isEmpty());
        Assert.assertNotNull((String)"Local broker ID is null.", (Object)this.remoteBrokerInfos.get(0).getBrokerId());
    }
}

