/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4220Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ4220Test.class);
    private static final int maxFileLength = 0x2000000;
    private static final String destinationName = "TEST.QUEUE";
    BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.prepareBrokerWithMultiStore(true);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    protected BrokerService createBroker(PersistenceAdapter kaha) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        broker.setBrokerName("localhost");
        broker.setPersistenceAdapter(kaha);
        return broker;
    }

    @Test
    public void testRestartAfterQueueDelete() throws Exception {
        Assert.assertTrue((String)"Broker doesn't have an Admin View.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ4220Test.this.broker.getAdminView() != null;
            }
        }));
        LOG.info("Adding initial destination: {}", (Object)destinationName);
        this.broker.getAdminView().addQueue(destinationName);
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(destinationName)));
        LOG.info("Removing initial destination: {}", (Object)destinationName);
        this.broker.getAdminView().removeQueue(destinationName);
        LOG.info("Adding back destination: {}", (Object)destinationName);
        this.broker.getAdminView().addQueue(destinationName);
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(destinationName)));
    }

    protected KahaDBPersistenceAdapter createStore(boolean delete) throws IOException {
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setJournalMaxFileLength(0x2000000);
        kaha.setCleanupInterval(5000L);
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    public void prepareBrokerWithMultiStore(boolean deleteAllMessages) throws Exception {
        MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter = new MultiKahaDBPersistenceAdapter();
        if (deleteAllMessages) {
            multiKahaDBPersistenceAdapter.deleteAllMessages();
        }
        ArrayList<FilteredKahaDBPersistenceAdapter> adapters = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        FilteredKahaDBPersistenceAdapter template = new FilteredKahaDBPersistenceAdapter();
        template.setPersistenceAdapter((PersistenceAdapter)this.createStore(deleteAllMessages));
        template.setPerDestination(true);
        adapters.add(template);
        multiKahaDBPersistenceAdapter.setFilteredPersistenceAdapters(adapters);
        this.broker = this.createBroker((PersistenceAdapter)multiKahaDBPersistenceAdapter);
    }
}

