/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.DemandForwardingBridgeSupport;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SimpleNetworkTest {
    protected static final int MESSAGE_COUNT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNetworkTest.class);
    protected AbstractApplicationContext context;
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQTopic included;
    protected ActiveMQTopic excluded;
    protected String consumerName = "durableSubs";

    @Test(timeout=60000L)
    public void testMessageCompression() throws Exception {
        ActiveMQConnection localAmqConnection = (ActiveMQConnection)this.localConnection;
        localAmqConnection.setUseCompression(true);
        MessageConsumer consumer1 = this.remoteSession.createConsumer((Destination)this.included);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        producer.setDeliveryMode(1);
        this.waitForConsumerRegistration(this.localBroker, 1, (ActiveMQDestination)this.included);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
            Message msg = consumer1.receive(3000L);
            Assert.assertNotNull((String)("not null? message: " + i), (Object)msg);
            ActiveMQMessage amqMessage = (ActiveMQMessage)msg;
            Assert.assertTrue((boolean)amqMessage.isCompressed());
        }
        Assert.assertNull((Object)consumer1.receive(1000L));
    }

    @Test(timeout=60000L)
    public void testRequestReply() throws Exception {
        final MessageProducer remoteProducer = this.remoteSession.createProducer(null);
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)this.included);
        remoteConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    TextMessage textMsg = (TextMessage)msg;
                    String payload = "REPLY: " + textMsg.getText();
                    Destination replyTo = msg.getJMSReplyTo();
                    textMsg.clearBody();
                    textMsg.setText(payload);
                    remoteProducer.send(replyTo, (Message)textMsg);
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        TopicRequestor requestor = new TopicRequestor((TopicSession)this.localSession, (Topic)this.included);
        Thread.sleep(5000L);
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = this.localSession.createTextMessage("test msg: " + i);
            TextMessage result = (TextMessage)requestor.request((Message)msg);
            Assert.assertNotNull((Object)result);
            LOG.info(result.getText());
        }
    }

    @Test(timeout=60000L)
    public void testFiltering() throws Exception {
        MessageConsumer includedConsumer = this.remoteSession.createConsumer((Destination)this.included);
        MessageConsumer excludedConsumer = this.remoteSession.createConsumer((Destination)this.excluded);
        MessageProducer includedProducer = this.localSession.createProducer((Destination)this.included);
        MessageProducer excludedProducer = this.localSession.createProducer((Destination)this.excluded);
        Thread.sleep(2000L);
        TextMessage test = this.localSession.createTextMessage("test");
        includedProducer.send((Message)test);
        excludedProducer.send((Message)test);
        Assert.assertNull((Object)excludedConsumer.receive(1000L));
        Assert.assertNotNull((Object)includedConsumer.receive(1000L));
    }

    @Test(timeout=60000L)
    public void testConduitBridge() throws Exception {
        MessageConsumer consumer1 = this.remoteSession.createConsumer((Destination)this.included);
        MessageConsumer consumer2 = this.remoteSession.createConsumer((Destination)this.included);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        producer.setDeliveryMode(1);
        this.waitForConsumerRegistration(this.localBroker, 2, (ActiveMQDestination)this.included);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
            Assert.assertNotNull((Object)consumer1.receive(1000L));
            Assert.assertNotNull((Object)consumer2.receive(1000L));
        }
        Assert.assertNull((Object)consumer1.receive(1000L));
        Assert.assertNull((Object)consumer2.receive(1000L));
    }

    private void waitForConsumerRegistration(final BrokerService brokerService, final int min, final ActiveMQDestination destination) throws Exception {
        Assert.assertTrue((String)"Internal bridge consumers registered in time", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                Object[] bridges = ((NetworkConnector)brokerService.getNetworkConnectors().get((int)0)).bridges.values().toArray();
                if (bridges.length > 0) {
                    LOG.info(brokerService + " bridges " + Arrays.toString(bridges));
                    DemandForwardingBridgeSupport demandForwardingBridgeSupport = (DemandForwardingBridgeSupport)bridges[0];
                    ConcurrentMap forwardingBridges = demandForwardingBridgeSupport.getLocalSubscriptionMap();
                    LOG.info(brokerService + " bridge " + demandForwardingBridgeSupport + ", localSubs: " + forwardingBridges);
                    if (!forwardingBridges.isEmpty()) {
                        for (DemandSubscription demandSubscription : forwardingBridges.values()) {
                            if (!demandSubscription.getLocalInfo().getDestination().equals((Object)destination)) continue;
                            LOG.info(brokerService + " DemandSubscription " + demandSubscription + ", size: " + demandSubscription.size());
                            return demandSubscription.size() >= min;
                        }
                    }
                }
                return false;
            }
        }));
    }

    @Test(timeout=60000L)
    public void testDurableTopicSubForwardMemoryUsage() throws Exception {
        TopicSubscriber remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        Thread.sleep(1000L);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)10L, (long)this.localBroker.getDestination((ActiveMQDestination)this.included).getDestinationStatistics().getForwards().getCount());
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return SimpleNetworkTest.this.localBroker.getSystemUsage().getMemoryUsage().getUsage() == 0L;
            }
        }, (long)10000L, (long)500L));
        remoteConsumer.close();
    }

    @Test(timeout=60000L)
    public void testTopicSubForwardMemoryUsage() throws Exception {
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)this.included);
        Thread.sleep(1000L);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)10L, (long)this.localBroker.getDestination((ActiveMQDestination)this.included).getDestinationStatistics().getForwards().getCount());
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return SimpleNetworkTest.this.localBroker.getSystemUsage().getMemoryUsage().getUsage() == 0L;
            }
        }, (long)10000L, (long)500L));
        remoteConsumer.close();
    }

    @Test(timeout=60000L)
    public void testQueueSubForwardMemoryUsage() throws Exception {
        ActiveMQQueue queue = new ActiveMQQueue("include.test.foo");
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)queue);
        Thread.sleep(1000L);
        MessageProducer producer = this.localSession.createProducer((Destination)queue);
        for (int i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)10L, (long)this.localBroker.getDestination((ActiveMQDestination)queue).getDestinationStatistics().getForwards().getCount());
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return SimpleNetworkTest.this.localBroker.getSystemUsage().getMemoryUsage().getUsage() == 0L;
            }
        }, (long)10000L, (long)500L));
        remoteConsumer.close();
    }

    @Test(timeout=60000L)
    public void testDurableStoreAndForward() throws Exception {
        int i;
        TopicSubscriber remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        Thread.sleep(1000L);
        this.doTearDown();
        this.doSetUp(false);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        for (i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)10L, (long)this.localBroker.getDestination((ActiveMQDestination)this.included).getDestinationStatistics().getForwards().getCount());
        this.doTearDown();
        this.doSetUp(false);
        remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        for (i = 0; i < 10; ++i) {
            Assert.assertNotNull((String)("message count: " + i), (Object)remoteConsumer.receive(2500L));
        }
    }

    @Ignore(value="This seems like a simple use case, but it is problematic to consume an existing topic store, it requires a connection per durable to match that connectionId")
    public void testDurableStoreAndForwardReconnect() throws Exception {
        int i;
        TopicSubscriber localConsumer = this.localSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        Thread.sleep(5000L);
        this.doTearDown();
        this.doSetUp(false);
        MessageProducer producer = this.localSession.createProducer((Destination)this.included);
        for (i = 0; i < 10; ++i) {
            TextMessage test = this.localSession.createTextMessage("test-" + i);
            producer.send((Message)test);
        }
        Thread.sleep(5000L);
        localConsumer = this.localSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        LOG.info("Consume from local consumer: " + localConsumer);
        for (i = 0; i < 5; ++i) {
            Assert.assertNotNull((String)("message count: " + i), (Object)localConsumer.receive(2500L));
        }
        Thread.sleep(5000L);
        this.doTearDown();
        this.doSetUp(false);
        Thread.sleep(5000L);
        LOG.info("Consume from remote");
        TopicSubscriber remoteConsumer = this.remoteSession.createDurableSubscriber((Topic)this.included, this.consumerName);
        LOG.info("Remote consumer: " + remoteConsumer);
        Thread.sleep(5000L);
        for (int i2 = 0; i2 < 5; ++i2) {
            Assert.assertNotNull((String)("message count: " + i2), (Object)remoteConsumer.receive(10000L));
        }
    }

    @Before
    public void setUp() throws Exception {
        this.doSetUp(true);
    }

    @After
    public void tearDown() throws Exception {
        this.doTearDown();
    }

    protected void doTearDown() throws Exception {
        this.localConnection.close();
        this.remoteConnection.close();
        this.localBroker.stop();
        this.remoteBroker.stop();
    }

    protected void doSetUp(boolean deleteAllMessages) throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
        this.localBroker = this.createLocalBroker();
        this.localBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        URI localURI = this.localBroker.getVmConnectorURI();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(localURI);
        fac.setAlwaysSyncSend(true);
        fac.setDispatchAsync(false);
        this.localConnection = fac.createConnection();
        this.localConnection.setClientID("clientId");
        this.localConnection.start();
        URI remoteURI = this.remoteBroker.getVmConnectorURI();
        fac = new ActiveMQConnectionFactory(remoteURI);
        this.remoteConnection = fac.createConnection();
        this.remoteConnection.setClientID("clientId");
        this.remoteConnection.start();
        this.included = new ActiveMQTopic("include.test.bar");
        this.excluded = new ActiveMQTopic("exclude.test.bar");
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker.xml";
    }

    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker.xml";
    }

    protected BrokerService createBroker(String uri) throws Exception {
        ClassPathResource resource = new ClassPathResource(uri);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        resource = new ClassPathResource(uri);
        factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService result = factory.getBroker();
        return result;
    }

    protected BrokerService createLocalBroker() throws Exception {
        return this.createBroker(this.getLocalBrokerURI());
    }

    protected BrokerService createRemoteBroker() throws Exception {
        return this.createBroker(this.getRemoteBrokerURI());
    }
}

