/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.TransactionRolledBackException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.transaction.Synchronization;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionContextTest {
    TransactionContext underTest;
    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
    ActiveMQConnection connection;

    @Before
    public void setup() throws Exception {
        this.connection = this.factory.createActiveMQConnection();
        this.underTest = new TransactionContext(this.connection);
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
    }

    @Test
    public void testSyncBeforeEndCalledOnceOnRollback() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger beforeEndCountB = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountB = new AtomicInteger(0);
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                if (beforeEndCountA.getAndIncrement() == 0) {
                    throw new TransactionRolledBackException("force rollback");
                }
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"exepcted rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        });
        this.underTest.addSynchronization(new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountB.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"exepcted rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountB.incrementAndGet();
            }
        });
        try {
            this.underTest.commit();
            Assert.fail((String)"exepcted rollback exception");
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            // empty catch block
        }
        Assert.assertEquals((String)"beforeEnd A called once", (long)1L, (long)beforeEndCountA.get());
        Assert.assertEquals((String)"beforeEnd B called once", (long)1L, (long)beforeEndCountA.get());
        Assert.assertEquals((String)"rollbackCount B 0", (long)1L, (long)rollbackCountB.get());
        Assert.assertEquals((String)"rollbackCount A B", (long)rollbackCountA.get(), (long)rollbackCountB.get());
    }

    @Test
    public void testSyncIndexCleared() throws Exception {
        final AtomicInteger beforeEndCountA = new AtomicInteger(0);
        final AtomicInteger rollbackCountA = new AtomicInteger(0);
        Synchronization sync = new Synchronization(){

            public void beforeEnd() throws Exception {
                beforeEndCountA.getAndIncrement();
            }

            public void afterCommit() throws Exception {
                Assert.fail((String)"exepcted rollback exception");
            }

            public void afterRollback() throws Exception {
                rollbackCountA.incrementAndGet();
            }
        };
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        Assert.assertEquals((String)"beforeEnd", (long)1L, (long)beforeEndCountA.get());
        Assert.assertEquals((String)"rollback", (long)1L, (long)rollbackCountA.get());
        this.underTest.begin();
        this.underTest.addSynchronization(sync);
        this.underTest.rollback();
        Assert.assertEquals((String)"beforeEnd", (long)2L, (long)beforeEndCountA.get());
        Assert.assertEquals((String)"rollback", (long)2L, (long)rollbackCountA.get());
    }
}

