/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.spring.SpringConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroPrefetchConsumerTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ZeroPrefetchConsumerTest.class);
    protected Connection connection;
    protected Queue queue;
    protected Queue brokerZeroQueue = new ActiveMQQueue("brokerZeroConfig");

    public void testCannotUseMessageListener() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        SpringConsumer listener = new SpringConsumer();
        try {
            consumer.setMessageListener((MessageListener)listener);
            ZeroPrefetchConsumerTest.fail((String)"Should have thrown JMSException as we cannot use MessageListener with zero prefetch");
        }
        catch (JMSException e) {
            LOG.info("Received expected exception : " + (Object)((Object)e));
        }
    }

    public void testPullConsumerWorks() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Hello World!"));
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        Message answer = consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertNotNull((String)"Should have received a message!", (Object)answer);
        answer = consumer.receive(1L);
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
        answer = consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testIdleConsumer() throws Exception {
        this.doTestIdleConsumer(false);
    }

    public void testIdleConsumerTranscated() throws Exception {
        this.doTestIdleConsumer(true);
    }

    private void doTestIdleConsumer(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        session.createConsumer((javax.jms.Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testRecvRecvCommit() throws Exception {
        this.doTestRecvRecvCommit(false);
    }

    public void testRecvRecvCommitTranscated() throws Exception {
        this.doTestRecvRecvCommit(true);
    }

    private void doTestRecvRecvCommit(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testTwoConsumers() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        MessageConsumer consumer1 = session.createConsumer((javax.jms.Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((javax.jms.Destination)this.queue);
        TextMessage answer = (TextMessage)consumer1.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        answer = (TextMessage)consumer2.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        answer = (TextMessage)consumer2.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testManyMessageConsumer() throws Exception {
        this.doTestManyMessageConsumer(true);
    }

    public void testManyMessageConsumerNoTransaction() throws Exception {
        this.doTestManyMessageConsumer(false);
    }

    private void doTestManyMessageConsumer(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, transacted ? 0 : 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        producer.send((Message)session.createTextMessage("Msg3"));
        producer.send((Message)session.createTextMessage("Msg4"));
        producer.send((Message)session.createTextMessage("Msg5"));
        producer.send((Message)session.createTextMessage("Msg6"));
        producer.send((Message)session.createTextMessage("Msg7"));
        producer.send((Message)session.createTextMessage("Msg8"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((javax.jms.Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg3");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg4");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg5");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg6");
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg7");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg8");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testManyMessageConsumerWithSend() throws Exception {
        this.doTestManyMessageConsumerWithSend(true);
    }

    public void testManyMessageConsumerWithTxSendPrioritySupport() throws Exception {
        ((ActiveMQConnection)this.connection).setMessagePrioritySupported(true);
        this.doTestManyMessageConsumerWithSend(true);
    }

    public void testManyMessageConsumerWithSendNoTransaction() throws Exception {
        this.doTestManyMessageConsumerWithSend(false);
    }

    private void doTestManyMessageConsumerWithSend(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, transacted ? 0 : 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        producer.send((Message)session.createTextMessage("Msg3"));
        producer.send((Message)session.createTextMessage("Msg4"));
        producer.send((Message)session.createTextMessage("Msg5"));
        producer.send((Message)session.createTextMessage("Msg6"));
        producer.send((Message)session.createTextMessage("Msg7"));
        producer.send((Message)session.createTextMessage("Msg8"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((javax.jms.Destination)this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg3");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg4");
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg5");
        producer.send((Message)session.createTextMessage("Msg9"));
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg6");
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg7");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer2.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg8");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg9");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testBrokerZeroPrefetchConfig() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((javax.jms.Destination)this.brokerZeroQueue);
        producer.send((Message)session.createTextMessage("Msg1"));
        MessageConsumer consumer = session.createConsumer((javax.jms.Destination)this.brokerZeroQueue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
    }

    public void testBrokerZeroPrefetchConfigWithConsumerControl() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((javax.jms.Destination)this.brokerZeroQueue);
        ZeroPrefetchConsumerTest.assertEquals((String)"broker config prefetch in effect", (int)0, (int)consumer.info.getCurrentPrefetchSize());
        Subscription sub = (Subscription)((Destination)this.broker.getRegionBroker().getDestinationMap().get(ActiveMQDestination.transform((javax.jms.Destination)this.brokerZeroQueue))).getConsumers().get(0);
        ZeroPrefetchConsumerTest.assertEquals((String)"broker sub prefetch is correct", (int)0, (int)sub.getConsumerInfo().getCurrentPrefetchSize());
        ConsumerControl consumerControl = new ConsumerControl();
        consumerControl.setConsumerId(consumer.info.getConsumerId());
        consumerControl.setDestination(ActiveMQDestination.transform((javax.jms.Destination)this.brokerZeroQueue));
        consumerControl.setPrefetch(1000);
        Object reply = ((ActiveMQConnection)this.connection).getTransport().request((Object)consumerControl);
        ZeroPrefetchConsumerTest.assertTrue((String)"good request", (!(reply instanceof ExceptionResponse) ? 1 : 0) != 0);
        ZeroPrefetchConsumerTest.assertEquals((String)"broker config prefetch in effect", (int)0, (int)consumer.info.getCurrentPrefetchSize());
        ZeroPrefetchConsumerTest.assertEquals((String)"broker sub prefetch is correct", (int)0, (int)sub.getConsumerInfo().getCurrentPrefetchSize());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService brokerService = super.createBroker();
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry zeroPrefetchPolicy = new PolicyEntry();
        zeroPrefetchPolicy.setQueuePrefetch(0);
        policyMap.put(ActiveMQDestination.transform((javax.jms.Destination)this.brokerZeroQueue), (Object)zeroPrefetchPolicy);
        brokerService.setDestinationPolicy(policyMap);
        return brokerService;
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.queue = this.createQueue();
    }

    @Override
    protected void startBroker() throws Exception {
        super.startBroker();
        this.bindAddress = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
    }

    @Override
    protected void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    protected Queue createQueue() {
        return new ActiveMQQueue(this.getDestinationString() + "?consumer.prefetchSize=0");
    }
}

