/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3625Test {
    protected BrokerService broker1;
    protected BrokerService broker2;
    protected AtomicBoolean authenticationFailed = new AtomicBoolean(false);
    protected AtomicBoolean gotNPE = new AtomicBoolean(false);
    protected String java_security_auth_login_config = "java.security.auth.login.config";
    protected String xbean = "xbean:";
    protected String base = "src/test/resources/org/apache/activemq/bugs/amq3625";
    protected String conf = "conf";
    protected String keys = "keys";
    protected String JaasStompSSLBroker1_xml = "JaasStompSSLBroker1.xml";
    protected String JaasStompSSLBroker2_xml = "JaasStompSSLBroker2.xml";
    protected String oldLoginConf = null;

    @Before
    public void before() throws Exception {
        if (System.getProperty(this.java_security_auth_login_config) != null) {
            this.oldLoginConf = System.getProperty(this.java_security_auth_login_config);
        }
        System.setProperty(this.java_security_auth_login_config, this.base + "/" + this.conf + "/" + "login.config");
        this.broker1 = BrokerFactory.createBroker((String)(this.xbean + this.base + "/" + this.conf + "/" + this.JaasStompSSLBroker1_xml));
        this.broker2 = BrokerFactory.createBroker((String)(this.xbean + this.base + "/" + this.conf + "/" + this.JaasStompSSLBroker2_xml));
        this.broker1.start();
        this.broker1.waitUntilStarted();
        this.broker2.start();
        this.broker2.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.broker1.stop();
        this.broker2.stop();
        if (this.oldLoginConf != null) {
            System.setProperty(this.java_security_auth_login_config, this.oldLoginConf);
        }
    }

    @Test
    public void go() throws Exception {
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getMessage().toString().contains("java.lang.SecurityException")) {
                    AMQ3625Test.this.authenticationFailed.set(true);
                }
                if (event.getMessage().toString().contains("NullPointerException")) {
                    AMQ3625Test.this.gotNPE.set(true);
                }
            }
        };
        Logger.getRootLogger().addAppender((Appender)appender);
        String connectURI = this.broker1.getConnectorByName("openwire").getConnectUri().toString();
        connectURI = connectURI.replace("?needClientAuth=true", "");
        this.broker2.addNetworkConnector("static:(" + connectURI + ")").start();
        Thread.sleep(10000L);
        Logger.getRootLogger().removeAppender((Appender)appender);
        Assert.assertTrue((boolean)this.authenticationFailed.get());
        Assert.assertFalse((boolean)this.gotNPE.get());
    }
}

