/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.Assert;

public class AMQ4116Test
extends EmbeddedBrokerTestSupport {
    private final String tcpAddr = "tcp://localhost:0";
    private String connectionUri;

    public void testVMTransport() throws Exception {
        this.runTest(this.connectionFactory);
    }

    public void testTCPTransport() throws Exception {
        this.runTest((ConnectionFactory)new ActiveMQConnectionFactory(this.connectionUri));
    }

    private void runTest(ConnectionFactory connFactory) throws Exception {
        org.apache.activemq.broker.region.Destination physicalDestination = this.broker.getDestination(this.destination);
        Assert.assertEquals((long)0L, (long)physicalDestination.getMemoryUsage().getUsage());
        Connection conn = connFactory.createConnection();
        conn.start();
        Session session = conn.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        producer.send((Message)new ActiveMQMessage());
        session.commit();
        Assert.assertTrue((physicalDestination.getMemoryUsage().getUsage() > 0L ? 1 : 0) != 0);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message received = consumer.receive();
        Assert.assertNotNull((Object)received);
        session.commit();
        Assert.assertEquals((long)0L, (long)physicalDestination.getMemoryUsage().getUsage());
        ActiveMQQueue secondDestination = new ActiveMQQueue(AMQ4116Test.class + ".second");
        MessageProducer secondPproducer = session.createProducer((Destination)secondDestination);
        secondPproducer.send(received);
        session.commit();
        Assert.assertEquals((long)0L, (long)physicalDestination.getMemoryUsage().getUsage());
        conn.stop();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        this.connectionUri = broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        return broker;
    }
}

