/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4930Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4930Test.class);
    final int messageCount = 150;
    final int messageSize = 0x100000;
    final int maxBrowsePageSize = 50;
    final ActiveMQQueue bigQueue = new ActiveMQQueue("BIG");
    BrokerService broker;
    ActiveMQConnectionFactory factory;

    protected void configureBroker() throws Exception {
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setAdvisorySupport(false);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x100000L);
        PolicyMap pMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(0L);
        policy.setMaxPageSize(50);
        policy.setMaxBrowsePageSize(50);
        pMap.setDefaultEntry(policy);
        this.broker.setDestinationPolicy(pMap);
    }

    public void testBrowsePendingNonPersistent() throws Exception {
        this.doTestBrowsePending(1);
    }

    public void testBrowsePendingPersistent() throws Exception {
        this.doTestBrowsePending(2);
    }

    public void testWithStatsDisabled() throws Exception {
        ((RegionBroker)this.broker.getRegionBroker()).getDestinationStatistics().setEnabled(false);
        this.doTestBrowsePending(2);
    }

    public void doTestBrowsePending(int deliveryMode) throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.bigQueue);
        producer.setDeliveryMode(deliveryMode);
        BytesMessage bytesMessage = session.createBytesMessage();
        bytesMessage.writeBytes(new byte[0x100000]);
        for (int i = 0; i < 150; ++i) {
            producer.send((Destination)this.bigQueue, (javax.jms.Message)bytesMessage);
        }
        QueueViewMBean queueViewMBean = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(this.broker.getAdminView().getQueues()[0], QueueViewMBean.class, false);
        LOG.info(queueViewMBean.getName() + " Size: " + queueViewMBean.getEnqueueCount());
        connection.close();
        AMQ4930Test.assertFalse((String)"Cache disabled on q", (boolean)queueViewMBean.isCacheEnabled());
        Queue underTest = (Queue)((RegionBroker)this.broker.getRegionBroker()).getQueueRegion().getDestinationMap().get(this.bigQueue);
        Message[] browsed = underTest.browse();
        LOG.info("Browsed: " + browsed.length);
        AMQ4930Test.assertEquals((String)"maxBrowsePageSize", (int)50, (int)browsed.length);
        browsed = underTest.browse();
        LOG.info("Browsed: " + browsed.length);
        AMQ4930Test.assertEquals((String)"maxBrowsePageSize", (int)50, (int)browsed.length);
        Runtime.getRuntime().gc();
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        LOG.info("free at start of check: " + free);
        for (int i = 0; i < 10; ++i) {
            LOG.info("free: " + Runtime.getRuntime().freeMemory() / 1024L);
            browsed = underTest.browse();
            LOG.info("Browsed: " + browsed.length);
            AMQ4930Test.assertEquals((String)"maxBrowsePageSize", (int)50, (int)browsed.length);
            Runtime.getRuntime().gc();
            Runtime.getRuntime().gc();
            AMQ4930Test.assertTrue((String)("No growth: " + Runtime.getRuntime().freeMemory() / 1024L + " >= " + ((double)free - (double)free * 0.2)), ((double)(Runtime.getRuntime().freeMemory() / 1024L) >= (double)free - (double)free * 0.2 ? 1 : 0) != 0);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setBrokerName("thisOne");
        this.configureBroker();
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory("vm://thisOne?jms.alwaysSyncSend=true");
        this.factory.setWatchTopicAdvisories(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }
}

