/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.config;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.sql.DataSource;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.FixedSizedSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.NoSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.StrictOrderDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.TimedSubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DefaultDatabaseLocker;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.adapter.TransactDatabaseLocker;
import org.apache.activemq.store.journal.JournalPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigTest {
    protected static final String JOURNAL_ROOT = "target/test-data/";
    protected static final String DERBY_ROOT = "target/test-data/";
    protected static final String CONF_ROOT = "src/test/resources/org/apache/activemq/config/sample-conf/";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournaledJDBCConfig() throws Exception {
        File journalFile = new File("target/test-data/testJournaledJDBCConfig/journal");
        ConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testJournaledJDBCConfig/derbydb");
        ConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/journaledjdbc-example.xml"));
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerJournaledJDBCConfigTest", (Object)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            Assert.assertTrue((String)"Should have created a journal persistence adapter", (boolean)(adapter instanceof JournalPersistenceAdapter));
            Assert.assertTrue((String)("Should have created a derby directory at " + derbyFile.getAbsolutePath()), (boolean)derbyFile.exists());
            Assert.assertTrue((String)("Should have created a journal directory at " + journalFile.getAbsolutePath()), (boolean)journalFile.exists());
            broker.getPersistenceAdapter();
            Assert.assertTrue((boolean)(broker.getSystemUsage().getStoreUsage().getStore() instanceof JournalPersistenceAdapter));
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    @Test
    public void testJdbcLockConfigOverride() throws Exception {
        JDBCPersistenceAdapter adapter = new JDBCPersistenceAdapter();
        Mockery context = new Mockery();
        final DataSource dataSource = (DataSource)context.mock(DataSource.class);
        final java.sql.Connection connection = (java.sql.Connection)context.mock(java.sql.Connection.class);
        final DatabaseMetaData metadata = (DatabaseMetaData)context.mock(DatabaseMetaData.class);
        final ResultSet result = (ResultSet)context.mock(ResultSet.class);
        adapter.setDataSource(dataSource);
        adapter.setCreateTablesOnStartup(false);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DataSource)this.allowing(dataSource)).getConnection();
                this.will(1.returnValue((Object)connection));
                ((java.sql.Connection)this.allowing(connection)).getMetaData();
                this.will(1.returnValue((Object)metadata));
                this.allowing(connection);
                ((DatabaseMetaData)this.allowing(metadata)).getDriverName();
                this.will(1.returnValue((Object)"Microsoft_SQL_Server_2005_jdbc_driver"));
                ((ResultSet)this.allowing(result)).next();
                this.will(1.returnValue((Object)true));
            }
        });
        adapter.start();
        Assert.assertTrue((String)"has the locker override", (boolean)(adapter.getLocker() instanceof TransactDatabaseLocker));
        adapter.stop();
    }

    public void testJdbcLockConfigDefault() throws Exception {
        JDBCPersistenceAdapter adapter = new JDBCPersistenceAdapter();
        Mockery context = new Mockery();
        final DataSource dataSource = (DataSource)context.mock(DataSource.class);
        final java.sql.Connection connection = (java.sql.Connection)context.mock(java.sql.Connection.class);
        final DatabaseMetaData metadata = (DatabaseMetaData)context.mock(DatabaseMetaData.class);
        final ResultSet result = (ResultSet)context.mock(ResultSet.class);
        adapter.setDataSource(dataSource);
        adapter.setCreateTablesOnStartup(false);
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DataSource)this.allowing(dataSource)).getConnection();
                this.will(2.returnValue((Object)connection));
                ((java.sql.Connection)this.allowing(connection)).getMetaData();
                this.will(2.returnValue((Object)metadata));
                this.allowing(connection);
                ((DatabaseMetaData)this.allowing(metadata)).getDriverName();
                this.will(2.returnValue((Object)"Some_Unknown_driver"));
                ((ResultSet)this.allowing(result)).next();
                this.will(2.returnValue((Object)true));
            }
        });
        adapter.start();
        Assert.assertEquals((String)"has the default locker", adapter.getLocker().getClass(), DefaultDatabaseLocker.class);
        adapter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrokerConfig() throws Exception {
        File journalFile = new File("target/test-data/");
        ConfigTest.recursiveDelete(journalFile);
        BrokerService broker = this.createBroker("org/apache/activemq/config/example.xml");
        LOG.info("Success");
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerConfigTest", (Object)broker.getBrokerName());
            Assert.assertEquals((String)"Broker Config Error (populateJMSXUserID)", (Object)false, (Object)broker.isPopulateJMSXUserID());
            Assert.assertEquals((String)"Broker Config Error (useLoggingForShutdownErrors)", (Object)true, (Object)broker.isUseLoggingForShutdownErrors());
            Assert.assertEquals((String)"Broker Config Error (useJmx)", (Object)true, (Object)broker.isUseJmx());
            Assert.assertEquals((String)"Broker Config Error (persistent)", (Object)false, (Object)broker.isPersistent());
            Assert.assertEquals((String)"Broker Config Error (useShutdownHook)", (Object)false, (Object)broker.isUseShutdownHook());
            Assert.assertEquals((String)"Broker Config Error (deleteAllMessagesOnStartup)", (Object)true, (Object)broker.isDeleteAllMessagesOnStartup());
            LOG.info("Success");
            Assert.assertEquals((String)"Should have a specific VM Connector", (Object)"vm://javacoola", (Object)broker.getVmConnectorURI().toString());
            LOG.info("Success");
            List connectors = broker.getTransportConnectors();
            Assert.assertTrue((String)"Should have created at least 3 connectors", (connectors.size() >= 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)"1st connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(0)).getServer() instanceof TcpTransportServer));
            Assert.assertTrue((String)"2nd connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(1)).getServer() instanceof TcpTransportServer));
            Assert.assertTrue((String)"3rd connector should be TcpTransportServer", (boolean)(((TransportConnector)connectors.get(2)).getServer() instanceof TcpTransportServer));
            List networkConnectors = broker.getNetworkConnectors();
            Assert.assertEquals((String)"Should have a single network connector", (long)1L, (long)networkConnectors.size());
            LOG.info("Success");
            ActiveMQTopic dest = new ActiveMQTopic("Topic.SimpleDispatch");
            Assert.assertTrue((String)("Should have a simple dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof SimpleDispatchPolicy));
            dest = new ActiveMQTopic("Topic.RoundRobinDispatch");
            Assert.assertTrue((String)("Should have a round robin dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof RoundRobinDispatchPolicy));
            dest = new ActiveMQTopic("Topic.StrictOrderDispatch");
            Assert.assertTrue((String)("Should have a strict order dispatch policy for " + dest.getTopicName()), (boolean)(broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getDispatchPolicy() instanceof StrictOrderDispatchPolicy));
            LOG.info("Success");
            dest = new ActiveMQTopic("Topic.FixedSizedSubs");
            SubscriptionRecoveryPolicy subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            Assert.assertTrue((String)("Should have a fixed sized subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof FixedSizedSubscriptionRecoveryPolicy));
            Assert.assertEquals((String)"FixedSizedSubsPolicy Config Error (maximumSize)", (long)2000000L, (long)((FixedSizedSubscriptionRecoveryPolicy)subsPolicy).getMaximumSize());
            Assert.assertEquals((String)"FixedSizedSubsPolicy Config Error (useSharedBuffer)", (Object)false, (Object)((FixedSizedSubscriptionRecoveryPolicy)subsPolicy).isUseSharedBuffer());
            dest = new ActiveMQTopic("Topic.LastImageSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            Assert.assertTrue((String)("Should have a last image subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof LastImageSubscriptionRecoveryPolicy));
            dest = new ActiveMQTopic("Topic.NoSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            Assert.assertTrue((String)("Should have no subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof NoSubscriptionRecoveryPolicy));
            dest = new ActiveMQTopic("Topic.TimedSubs");
            subsPolicy = broker.getDestinationPolicy().getEntryFor((ActiveMQDestination)dest).getSubscriptionRecoveryPolicy();
            Assert.assertTrue((String)("Should have a timed subscription recovery policy for " + dest.getTopicName()), (boolean)(subsPolicy instanceof TimedSubscriptionRecoveryPolicy));
            Assert.assertEquals((String)"TimedSubsPolicy Config Error (recoverDuration)", (long)25000L, (long)((TimedSubscriptionRecoveryPolicy)subsPolicy).getRecoverDuration());
            LOG.info("Success");
            SystemUsage systemUsage = broker.getSystemUsage();
            Assert.assertTrue((String)"Should have a SystemUsage", (systemUsage != null ? 1 : 0) != 0);
            Assert.assertEquals((String)"SystemUsage Config Error (MemoryUsage.limit)", (long)0xA00000L, (long)systemUsage.getMemoryUsage().getLimit());
            Assert.assertEquals((String)"SystemUsage Config Error (MemoryUsage.percentUsageMinDelta)", (long)20L, (long)systemUsage.getMemoryUsage().getPercentUsageMinDelta());
            Assert.assertEquals((String)"SystemUsage Config Error (TempUsage.limit)", (long)0x6400000L, (long)systemUsage.getTempUsage().getLimit());
            Assert.assertEquals((String)"SystemUsage Config Error (StoreUsage.limit)", (long)0x40000000L, (long)systemUsage.getStoreUsage().getLimit());
            Assert.assertEquals((String)"SystemUsage Config Error (StoreUsage.name)", (Object)"foo", (Object)systemUsage.getStoreUsage().getName());
            Assert.assertNotNull((Object)systemUsage.getStoreUsage().getStore());
            Assert.assertTrue((boolean)(systemUsage.getStoreUsage().getStore() instanceof MemoryPersistenceAdapter));
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournalConfig() throws Exception {
        File journalFile = new File("target/test-data/testJournalConfig/journal");
        ConfigTest.recursiveDelete(journalFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/journal-example.xml"));
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerJournalConfigTest", (Object)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            Assert.assertTrue((String)"Should have created a journal persistence adapter", (boolean)(adapter instanceof JournalPersistenceAdapter));
            Assert.assertTrue((String)("Should have created a journal directory at " + journalFile.getAbsolutePath()), (boolean)journalFile.exists());
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemoryConfig() throws Exception {
        File journalFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/memory-example.xml"));
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerMemoryConfigTest", (Object)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            Assert.assertTrue((String)"Should have created a memory persistence adapter", (boolean)(adapter instanceof MemoryPersistenceAdapter));
            Assert.assertTrue((String)("Should have not created a derby directory at " + derbyFile.getAbsolutePath()), (!derbyFile.exists() ? 1 : 0) != 0);
            Assert.assertTrue((String)("Should have not created a journal directory at " + journalFile.getAbsolutePath()), (!journalFile.exists() ? 1 : 0) != 0);
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectorConfig() throws Exception {
        File journalFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testMemoryConfig");
        ConfigTest.recursiveDelete(derbyFile);
        int MAX_PRODUCERS = 5;
        int MAX_CONSUMERS = 10;
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/connector-properties.xml"));
        broker.start();
        try {
            Assert.assertEquals((long)broker.getTransportConnectorByScheme("tcp").getMaximumProducersAllowedPerConnection(), (long)5L);
            Assert.assertEquals((long)broker.getTransportConnectorByScheme("tcp").getMaximumConsumersAllowedPerConnection(), (long)10L);
            ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61631");
            Connection connection = activeMQConnectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic("test.foo");
            for (int i = 0; i < 5; ++i) {
                session.createProducer((Destination)topic);
            }
            try {
                session.createProducer((Destination)topic);
                Assert.fail((String)"Should have got an exception on exceeding MAX_PRODUCERS");
            }
            catch (JMSException i) {
                // empty catch block
            }
            try {
                session.createProducer(null);
                Assert.fail((String)"Should have got an exception on exceeding MAX_PRODUCERS");
            }
            catch (JMSException i) {
                // empty catch block
            }
            try {
                for (int i = 0; i < 11; ++i) {
                    MessageConsumer consumer = session.createConsumer((Destination)topic);
                    Assert.assertNotNull((Object)consumer);
                }
                Assert.fail((String)"Should have caught an exception");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlConfigHelper() throws Exception {
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/memory-example.xml"));
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerMemoryConfigTest", (Object)broker.getBrokerName());
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
        broker = this.createBroker("org/apache/activemq/config/config.xml");
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerXmlConfigHelper", (Object)broker.getBrokerName());
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    protected static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                ConfigTest.recursiveDelete(files[i]);
            }
        }
        file.delete();
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return this.createBroker((Resource)new ClassPathResource(resource));
    }

    protected BrokerService createBroker(Resource resource) throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean(resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        Assert.assertTrue((String)"Should have a broker!", (broker != null ? 1 : 0) != 0);
        return broker;
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/client.keystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/server.keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
    }
}

