/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.NetworkBridgeFilter;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v1.ActiveMQTextMessageTest;
import org.apache.activemq.openwire.v1.BrokerInfoTest;
import org.apache.activemq.openwire.v1.MessageAckTest;
import org.apache.activemq.test.TestSupport;
import org.apache.activemq.util.ByteSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataFileGeneratorTestSupport
extends TestSupport {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static final Logger LOG = LoggerFactory.getLogger(DataFileGeneratorTestSupport.class);
    private static final Throwable SINGLETON_EXCEPTION = new Exception("shared exception");
    private static final File MODULE_BASE_DIR;
    private static final File CONTROL_DIR;
    private int counter;
    private OpenWireFormat openWireformat;

    public void xtestControlFileIsValid() throws Exception {
        this.generateControlFile();
        this.assertControlFileIsEqual();
    }

    public void testGenerateAndReParsingIsTheSame() throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buffer);
        Object expected = this.createObject();
        LOG.info("Created: " + expected);
        this.openWireformat.marshal(expected, (DataOutput)ds);
        ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        Object actual = this.openWireformat.unmarshal((DataInput)dis);
        this.assertBeansEqual("", new HashSet<Object>(), expected, actual);
        LOG.info("Parsed: " + actual);
    }

    protected void assertBeansEqual(String message, Set<Object> comparedObjects, Object expected, Object actual) throws Exception {
        DataFileGeneratorTestSupport.assertNotNull((String)("Actual object should be equal to: " + expected + " but was null"), (Object)actual);
        if (comparedObjects.contains(expected)) {
            return;
        }
        comparedObjects.add(expected);
        Class<?> type = expected.getClass();
        DataFileGeneratorTestSupport.assertEquals((String)"Should be of same type", type, actual.getClass());
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            Method method = descriptor.getReadMethod();
            if (method == null) continue;
            String name = descriptor.getName();
            Object expectedValue = null;
            Object actualValue = null;
            try {
                expectedValue = method.invoke(expected, EMPTY_ARGUMENTS);
                actualValue = method.invoke(actual, EMPTY_ARGUMENTS);
            }
            catch (Exception e) {
                LOG.info("Failed to access property: " + name);
            }
            this.assertPropertyValuesEqual(message + name, comparedObjects, expectedValue, actualValue);
        }
    }

    protected void assertPropertyValuesEqual(String name, Set<Object> comparedObjects, Object expectedValue, Object actualValue) throws Exception {
        String message = "Property " + name + " not equal";
        if (expectedValue == null) {
            DataFileGeneratorTestSupport.assertNull((String)("Property " + name + " should be null"), (Object)actualValue);
        } else if (expectedValue instanceof Object[]) {
            this.assertArrayEqual(message, comparedObjects, (Object[])expectedValue, (Object[])actualValue);
        } else if (expectedValue.getClass().isArray()) {
            this.assertPrimitiveArrayEqual(message, comparedObjects, expectedValue, actualValue);
        } else if (expectedValue instanceof Exception) {
            this.assertExceptionsEqual(message, (Exception)expectedValue, actualValue);
        } else if (expectedValue instanceof ByteSequence) {
            this.assertByteSequencesEqual(message, (ByteSequence)expectedValue, actualValue);
        } else if (expectedValue instanceof DataStructure) {
            this.assertBeansEqual(message + name, comparedObjects, expectedValue, actualValue);
        } else if (expectedValue instanceof Enumeration) {
            this.assertEnumerationEqual(message + name, comparedObjects, (Enumeration)expectedValue, (Enumeration)actualValue);
        } else {
            DataFileGeneratorTestSupport.assertEquals((String)message, (Object)expectedValue, (Object)actualValue);
        }
    }

    protected void assertArrayEqual(String message, Set<Object> comparedObjects, Object[] expected, Object[] actual) throws Exception {
        DataFileGeneratorTestSupport.assertEquals((String)(message + ". Array length"), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            this.assertPropertyValuesEqual(message + ". element: " + i, comparedObjects, expected[i], actual[i]);
        }
    }

    protected void assertEnumerationEqual(String message, Set<Object> comparedObjects, Enumeration<?> expected, Enumeration<?> actual) throws Exception {
        while (expected.hasMoreElements()) {
            Object expectedElem = expected.nextElement();
            Object actualElem = actual.nextElement();
            this.assertPropertyValuesEqual(message + ". element: " + expectedElem, comparedObjects, expectedElem, actualElem);
        }
    }

    protected void assertPrimitiveArrayEqual(String message, Set<Object> comparedObjects, Object expected, Object actual) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        int length = Array.getLength(expected);
        DataFileGeneratorTestSupport.assertEquals((String)(message + ". Array length"), (int)length, (int)Array.getLength(actual));
        for (int i = 0; i < length; ++i) {
            this.assertPropertyValuesEqual(message + ". element: " + i, comparedObjects, Array.get(expected, i), Array.get(actual, i));
        }
    }

    protected void assertByteSequencesEqual(String message, ByteSequence expected, Object actualValue) {
        DataFileGeneratorTestSupport.assertTrue((String)(message + ". Actual value should be a ByteSequence but was: " + actualValue), (boolean)(actualValue instanceof ByteSequence));
        ByteSequence actual = (ByteSequence)actualValue;
        int length = expected.getLength();
        DataFileGeneratorTestSupport.assertEquals((String)(message + ". Length"), (int)length, (int)actual.getLength());
        int offset = expected.getOffset();
        DataFileGeneratorTestSupport.assertEquals((String)(message + ". Offset"), (int)offset, (int)actual.getOffset());
        byte[] data = expected.getData();
        byte[] actualData = actual.getData();
        for (int i = 0; i < length; ++i) {
            DataFileGeneratorTestSupport.assertEquals((String)(message + ". Offset " + i), (byte)data[offset + i], (byte)actualData[offset + i]);
        }
    }

    protected void assertExceptionsEqual(String message, Exception expected, Object actualValue) {
        DataFileGeneratorTestSupport.assertTrue((String)(message + ". Actual value should be an exception but was: " + actualValue), (boolean)(actualValue instanceof Exception));
        Exception actual = (Exception)actualValue;
        DataFileGeneratorTestSupport.assertEquals((String)message, (String)expected.getMessage(), (String)actual.getMessage());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openWireformat = this.createOpenWireFormat();
    }

    public void generateControlFile() throws Exception {
        CONTROL_DIR.mkdirs();
        File dataFile = new File(CONTROL_DIR, ((Object)((Object)this)).getClass().getName() + ".bin");
        FileOutputStream os = new FileOutputStream(dataFile);
        DataOutputStream ds = new DataOutputStream(os);
        this.openWireformat.marshal(this.createObject(), (DataOutput)ds);
        ds.close();
    }

    public InputStream generateInputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(os);
        this.openWireformat.marshal(this.createObject(), (DataOutput)ds);
        ds.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertControlFileIsEqual() throws Exception {
        File dataFile = new File(CONTROL_DIR, ((Object)((Object)this)).getClass().getName() + ".bin");
        int pos = 0;
        try (FileInputStream is1 = new FileInputStream(dataFile);){
            InputStream is2 = this.generateInputStream();
            int a = is1.read();
            int b = is2.read();
            DataFileGeneratorTestSupport.assertEquals((String)("Data does not match control file: " + dataFile + " at byte position " + ++pos), (int)a, (int)b);
            while (a >= 0 && b >= 0) {
                a = is1.read();
                b = is2.read();
                DataFileGeneratorTestSupport.assertEquals((String)("Data does not match control file: " + dataFile + " at byte position " + ++pos), (int)a, (int)b);
            }
            is2.close();
        }
    }

    protected abstract Object createObject() throws Exception;

    protected void populateObject(Object info) throws Exception {
    }

    protected OpenWireFormat createOpenWireFormat() {
        OpenWireFormat wf = new OpenWireFormat();
        wf.setCacheEnabled(true);
        wf.setStackTraceEnabled(false);
        wf.setVersion(10);
        return wf;
    }

    protected BrokerId createBrokerId(String text) {
        return new BrokerId(text);
    }

    protected TransactionId createTransactionId(String string) {
        return new LocalTransactionId(this.createConnectionId(string), (long)(++this.counter));
    }

    protected ConnectionId createConnectionId(String string) {
        return new ConnectionId(string);
    }

    protected SessionId createSessionId(String string) {
        return new SessionId(this.createConnectionId(string), (long)(++this.counter));
    }

    protected ProducerId createProducerId(String string) {
        return new ProducerId(this.createSessionId(string), (long)(++this.counter));
    }

    protected ConsumerId createConsumerId(String string) {
        return new ConsumerId(this.createSessionId(string), (long)(++this.counter));
    }

    protected MessageId createMessageId(String string) {
        return new MessageId(this.createProducerId(string), (long)(++this.counter));
    }

    protected ActiveMQDestination createActiveMQDestination(String string) {
        return new ActiveMQQueue(string);
    }

    protected Message createMessage(String string) throws Exception {
        ActiveMQTextMessage message = (ActiveMQTextMessage)ActiveMQTextMessageTest.SINGLETON.createObject();
        message.setText(string);
        return message;
    }

    protected BrokerInfo createBrokerInfo(String string) throws Exception {
        return (BrokerInfo)BrokerInfoTest.SINGLETON.createObject();
    }

    protected MessageAck createMessageAck(String string) throws Exception {
        return (MessageAck)MessageAckTest.SINGLETON.createObject();
    }

    protected DataStructure createDataStructure(String string) throws Exception {
        return this.createBrokerInfo(string);
    }

    protected Throwable createThrowable(String string) {
        return SINGLETON_EXCEPTION;
    }

    protected BooleanExpression createBooleanExpression(String string) {
        return new NetworkBridgeFilter(null, new BrokerId(string), 10, 10);
    }

    static {
        File basedir = null;
        try {
            URL resource = DataFileGeneratorTestSupport.class.getResource("DataFileGeneratorTestSupport.class");
            URI baseURI = new URI(resource.toString()).resolve("../../../../..");
            basedir = new File(baseURI).getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MODULE_BASE_DIR = basedir;
        CONTROL_DIR = new File(MODULE_BASE_DIR, "src/test/resources/openwire-control");
    }
}

