/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.selector;

import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnknownHandlingSelectorTest {
    private javax.jms.Message message;

    @Before
    public void setUp() throws Exception {
        this.message = new ActiveMQMessage();
        this.message.setJMSDestination((Destination)new ActiveMQTopic("FOO.BAR"));
        this.message.setJMSType("selector-test");
        this.message.setJMSMessageID("connection:1:1:1:1");
        this.message.setBooleanProperty("trueProp", true);
        this.message.setBooleanProperty("falseProp", false);
        this.message.setObjectProperty("nullProp", null);
    }

    @Test
    public void notEvaluation() throws Exception {
        this.assertSelector("not(trueProp)", false);
        this.assertSelector("not(falseProp)", true);
        this.assertSelector("not(unknownProp)", false);
    }

    @Test
    public void andEvaluation() throws Exception {
        this.assertSelectorEvaluatesToTrue("trueProp AND trueProp");
        this.assertSelectorEvaluatesToFalse("trueProp AND falseProp");
        this.assertSelectorEvaluatesToFalse("falseProp AND trueProp");
        this.assertSelectorEvaluatesToFalse("falseProp AND falseProp");
        this.assertSelectorEvaluatesToFalse("falseProp AND unknownProp");
        this.assertSelectorEvaluatesToFalse("unknownProp AND falseProp");
        this.assertSelectorEvaluatesToUnknown("trueProp AND unknownProp");
        this.assertSelectorEvaluatesToUnknown("unknownProp AND trueProp");
        this.assertSelectorEvaluatesToUnknown("unknownProp AND unknownProp");
    }

    @Test
    public void orEvaluation() throws Exception {
        this.assertSelectorEvaluatesToTrue("trueProp OR trueProp");
        this.assertSelectorEvaluatesToTrue("trueProp OR falseProp");
        this.assertSelectorEvaluatesToTrue("falseProp OR trueProp");
        this.assertSelectorEvaluatesToTrue("trueProp OR unknownProp");
        this.assertSelectorEvaluatesToTrue("unknownProp OR trueProp");
        this.assertSelectorEvaluatesToFalse("falseProp OR falseProp");
        this.assertSelectorEvaluatesToUnknown("falseProp OR unknownProp");
        this.assertSelectorEvaluatesToUnknown("unknownProp OR falseProp");
        this.assertSelectorEvaluatesToUnknown("unknownProp OR unknownProp");
    }

    @Test
    public void comparisonWithUnknownShouldEvaluateToUnknown() throws Exception {
        this.assertSelectorEvaluatesToUnknown("unknownProp = 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp > 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp >= 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp < 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp <= 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp <> 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp LIKE 'zero'");
        this.assertSelectorEvaluatesToUnknown("unknownProp NOT LIKE 'zero'");
        this.assertSelectorEvaluatesToUnknown("unknownProp IN ('zero')");
        this.assertSelectorEvaluatesToUnknown("unknownProp NOT IN ('zero')");
        this.assertSelectorEvaluatesToUnknown("unknownProp BETWEEN 1 AND 2");
        this.assertSelectorEvaluatesToUnknown("unknownProp NOT BETWEEN 1 AND 2");
    }

    @Test
    public void comparisonWithNullPropShouldEvaluateToUnknown() throws Exception {
        this.assertSelectorEvaluatesToUnknown("nullProp = 0");
        this.assertSelectorEvaluatesToUnknown("nullProp > 0");
        this.assertSelectorEvaluatesToUnknown("nullProp >= 0");
        this.assertSelectorEvaluatesToUnknown("nullProp < 0");
        this.assertSelectorEvaluatesToUnknown("nullProp <= 0");
        this.assertSelectorEvaluatesToUnknown("nullProp <> 0");
        this.assertSelectorEvaluatesToUnknown("nullProp LIKE 'zero'");
        this.assertSelectorEvaluatesToUnknown("nullProp NOT LIKE 'zero'");
        this.assertSelectorEvaluatesToUnknown("nullProp IN ('zero')");
        this.assertSelectorEvaluatesToUnknown("nullProp NOT IN ('zero')");
        this.assertSelectorEvaluatesToUnknown("nullProp BETWEEN 1 AND 2");
        this.assertSelectorEvaluatesToUnknown("nullProp NOT BETWEEN 1 AND 2");
    }

    @Test
    public void isNullIsNotNull() throws Exception {
        this.assertSelectorEvaluatesToTrue("unknownProp IS NULL");
        this.assertSelectorEvaluatesToTrue("nullProp IS NULL");
        this.assertSelectorEvaluatesToFalse("trueProp IS NULL");
        this.assertSelectorEvaluatesToFalse("unknownProp IS NOT NULL");
        this.assertSelectorEvaluatesToFalse("nullProp IS NOT NULL");
        this.assertSelectorEvaluatesToTrue("trueProp IS NOT NULL");
    }

    @Test
    public void arithmeticWithNull() throws Exception {
        this.assertSelectorEvaluatesToUnknown("-unknownProp = 0");
        this.assertSelectorEvaluatesToUnknown("+unknownProp = 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp * 2 = 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp / 2 = 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp + 2 = 0");
        this.assertSelectorEvaluatesToUnknown("unknownProp - 2 = 0");
    }

    protected void assertSelectorEvaluatesToUnknown(String selector) throws JMSException {
        this.assertSelector(selector, false);
        this.assertSelector(UnknownHandlingSelectorTest.not(selector), false);
    }

    protected void assertSelectorEvaluatesToTrue(String selector) throws JMSException {
        this.assertSelector(selector, true);
        this.assertSelector(UnknownHandlingSelectorTest.not(selector), false);
    }

    protected void assertSelectorEvaluatesToFalse(String selector) throws JMSException {
        this.assertSelector(selector, false);
        this.assertSelector(UnknownHandlingSelectorTest.not(selector), true);
    }

    protected void assertSelector(String text, boolean matches) throws JMSException {
        BooleanExpression selector = SelectorParser.parse((String)text);
        Assert.assertTrue((String)"Created a valid selector", (selector != null ? 1 : 0) != 0);
        MessageEvaluationContext context = new MessageEvaluationContext();
        context.setMessageReference((MessageReference)((Message)this.message));
        boolean value = selector.matches(context);
        Assert.assertEquals((String)("Selector for: " + text), (Object)matches, (Object)value);
    }

    private static String not(String selector) {
        return "not(" + selector + ")";
    }
}

