/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.SharedFileLocker;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.apache.commons.io.FileUtils;

public class MKahaDbSharedLockerTest
extends TestCase {
    public void testBrokerShutdown() throws Exception {
        final BrokerService master = new BrokerService();
        master.setBrokerName("master");
        master.setUseJmx(false);
        master.setPersistent(true);
        master.setDeleteAllMessagesOnStartup(true);
        MultiKahaDBPersistenceAdapter mKahaDB = new MultiKahaDBPersistenceAdapter();
        mKahaDB.setDirectory(new File("target/test/kahadb"));
        LinkedList<FilteredKahaDBPersistenceAdapter> adapters = new LinkedList<FilteredKahaDBPersistenceAdapter>();
        FilteredKahaDBPersistenceAdapter defaultEntry = new FilteredKahaDBPersistenceAdapter();
        defaultEntry.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
        defaultEntry.setPerDestination(true);
        adapters.add(defaultEntry);
        mKahaDB.setFilteredPersistenceAdapters(adapters);
        master.setPersistenceAdapter((PersistenceAdapter)mKahaDB);
        SharedFileLocker sharedFileLocker = new SharedFileLocker();
        mKahaDB.setLockKeepAlivePeriod(1000L);
        mKahaDB.setLocker((Locker)sharedFileLocker);
        master.start();
        master.waitUntilStarted();
        FileUtils.forceDelete((File)new File("target/test/kahadb/lock"));
        MKahaDbSharedLockerTest.assertTrue((String)"broker should be stopped now", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return master.isStopped();
            }
        }));
        master.stop();
        master.waitUntilStopped();
    }
}

