/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.bugs.embedded.ThreadExplorer;
import org.apache.activemq.network.NetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmTransportNetworkBrokerTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(VmTransportNetworkBrokerTest.class);
    private static final String VM_BROKER_URI = "vm://localhost?create=false";
    CountDownLatch started = new CountDownLatch(1);
    CountDownLatch gotConnection = new CountDownLatch(1);

    public void testNoThreadLeak() throws Exception {
        int originalThreadCount = Thread.activeCount();
        LOG.debug(ThreadExplorer.show("threads at beginning"));
        BrokerService broker = new BrokerService();
        broker.setDedicatedTaskRunner(true);
        broker.setPersistent(false);
        broker.addConnector("tcp://localhost:61616");
        NetworkConnector networkConnector = broker.addNetworkConnector("static:(tcp://wrongHostname1:61617,tcp://wrongHostname2:61618)?useExponentialBackOff=false");
        networkConnector.setDuplex(true);
        broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI));
        Connection connection = cf.createConnection("system", "manager");
        connection.start();
        TimeUnit.SECONDS.sleep(5L);
        int threadCountAfterStart = Thread.activeCount();
        TimeUnit.SECONDS.sleep(30L);
        int threadCountAfterSleep = Thread.activeCount();
        VmTransportNetworkBrokerTest.assertTrue((String)("Threads are leaking: " + ThreadExplorer.show("active sleep") + ", threadCount=" + threadCountAfterStart + " threadCountAfterSleep=" + threadCountAfterSleep), (threadCountAfterSleep < threadCountAfterStart + 8 ? 1 : 0) != 0);
        connection.close();
        broker.stop();
        broker.waitUntilStopped();
        broker = new BrokerService();
        broker.setSchedulerSupport(true);
        broker.setDedicatedTaskRunner(true);
        broker.setPersistent(false);
        broker.addConnector("tcp://localhost:61616?wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000");
        broker.start();
        cf = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.maxInactivityDuration=1000&wireFormat.maxInactivityDurationInitalDelay=1000");
        connection = cf.createConnection("system", "manager");
        connection.start();
        connection.close();
        broker.stop();
        broker.waitUntilStopped();
        TimeUnit.SECONDS.sleep(5L);
        Thread[] threads = this.filterDaemonThreads(ThreadExplorer.listThreads());
        int threadCountAfterStop = threads.length;
        LOG.info(ThreadExplorer.show("active after stop"));
        LOG.info("originalThreadCount=" + originalThreadCount + " threadCountAfterStop=" + threadCountAfterStop);
        VmTransportNetworkBrokerTest.assertTrue((String)("Threads are leaking: " + ThreadExplorer.show("active after stop") + ". originalThreadCount=" + originalThreadCount + " threadCountAfterStop=" + threadCountAfterStop), (threadCountAfterStop <= originalThreadCount ? 1 : 0) != 0);
    }

    public Thread[] filterDaemonThreads(Thread[] threads) throws Exception {
        ArrayList<Thread> threadList = new ArrayList<Thread>(Arrays.asList(threads));
        for (int i = 0; i < threadList.size(); ++i) {
            Thread thread = (Thread)threadList.get(i);
            LOG.debug("Inspecting thread " + thread.getName());
            if (!thread.isDaemon()) continue;
            LOG.debug("Removing deamon thread.");
            threadList.remove(thread);
            Thread.sleep(100L);
        }
        LOG.debug("Converting list back to Array");
        return threadList.toArray(new Thread[0]);
    }
}

