/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ServerSocketFactory;
import javax.transaction.xa.Xid;

public class TestUtils {
    public static final int DEFAULT_PORT = 61616;
    private static AtomicLong txGenerator = new AtomicLong(System.currentTimeMillis());

    public static int findOpenPort() {
        return TestUtils.findOpenPorts(1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> findOpenPorts(int count) {
        int i;
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>(count);
        ArrayList<Integer> ports = new ArrayList<Integer>(count);
        ArrayList<Integer> safeSet = new ArrayList<Integer>(count);
        for (i = 0; i < count; ++i) {
            safeSet.add(61616 + i);
        }
        try {
            for (i = 0; i < count; ++i) {
                ServerSocket socket = ServerSocketFactory.getDefault().createServerSocket(0);
                sockets.add(socket);
                ports.add(socket.getLocalPort());
            }
        }
        catch (IOException e) {
            ArrayList<Integer> arrayList = safeSet;
            return arrayList;
        }
        finally {
            for (ServerSocket socket : sockets) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ports;
    }

    public static Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(txGenerator.incrementAndGet());
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            @Override
            public int getFormatId() {
                return 86;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return bs;
            }

            @Override
            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }
}

