/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerFlowControlTest
extends JmsTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(ProducerFlowControlTest.class);
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    ActiveMQQueue queueB = new ActiveMQQueue("QUEUE.B");
    protected TransportConnector connector;
    protected ActiveMQConnection connection;
    protected final AtomicBoolean gotResourceException = new AtomicBoolean(false);

    public void test2ndPubisherWithProducerWindowSendConnectionThatIsBlocked() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setProducerWindowSize(65536);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void testPubisherRecoverAfterBlock() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        final Session session = this.connection.createSession(false, 2);
        final MessageProducer producer = session.createProducer((Destination)this.queueA);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        Thread thread = new Thread("Filler"){
            int i;

            @Override
            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    try {
                        producer.send((Message)session.createTextMessage("Test message " + ++this.i));
                        LOG.info("sent: " + this.i);
                    }
                    catch (JMSException jMSException) {}
                }
            }
        };
        thread.start();
        this.waitForBlockedOrResourceLimit(done);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 5; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            LOG.info("received: " + idx + ", msg: " + msg.getJMSMessageID());
            msg.acknowledge();
        }
        Thread.sleep(1000L);
        keepGoing.set(false);
        ProducerFlowControlTest.assertFalse((String)"producer has resumed", (boolean)done.get());
    }

    public void testAsyncPubisherRecoverAfterBlock() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setProducerWindowSize(5120);
        factory.setUseAsyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        final Session session = this.connection.createSession(false, 2);
        final MessageProducer producer = session.createProducer((Destination)this.queueA);
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        Thread thread = new Thread("Filler"){
            int i;

            @Override
            public void run() {
                while (keepGoing.get()) {
                    done.set(false);
                    try {
                        producer.send((Message)session.createTextMessage("Test message " + ++this.i));
                        LOG.info("sent: " + this.i);
                    }
                    catch (JMSException jMSException) {}
                }
            }
        };
        thread.start();
        this.waitForBlockedOrResourceLimit(done);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 5; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(1000L);
            ProducerFlowControlTest.assertNotNull((String)"Got a message", (Object)msg);
            LOG.info("received: " + idx + ", msg: " + msg.getJMSMessageID());
            msg.acknowledge();
        }
        Thread.sleep(1000L);
        keepGoing.set(false);
        ProducerFlowControlTest.assertFalse((String)"producer has resumed", (boolean)done.get());
    }

    public void test2ndPubisherWithSyncSendConnectionThatIsBlocked() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setAlwaysSyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueB);
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void testSimpleSendReceive() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setAlwaysSyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        CountDownLatch pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuA = this.asyncSendTo(this.queueA, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuA.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void test2ndPubisherWithStandardConnectionThatIsBlocked() throws Exception {
        ConnectionFactory factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertFalse((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisableWarning() throws Exception {
        final AtomicInteger warnings = new AtomicInteger();
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getLevel().equals((Object)Level.INFO) && event.getMessage().toString().contains("Usage Manager Memory Limit")) {
                    LOG.info("received  log message: " + event.getMessage());
                    warnings.incrementAndGet();
                }
            }
        };
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger(Queue.class);
        log4jLogger.addAppender((Appender)appender);
        try {
            ConnectionFactory factory = this.createConnectionFactory();
            this.connection = (ActiveMQConnection)factory.createConnection();
            this.connections.add(this.connection);
            this.connection.start();
            this.fillQueue(this.queueB);
            ProducerFlowControlTest.assertEquals((int)1, (int)warnings.get());
            this.broker.getDestinationPolicy().getDefaultEntry().setBlockedProducerWarningInterval(0L);
            warnings.set(0);
            this.connection = (ActiveMQConnection)factory.createConnection();
            this.connections.add(this.connection);
            this.connection.start();
            this.fillQueue(new ActiveMQQueue("SomeOtherQueueToPickUpNewPolicy"));
            ProducerFlowControlTest.assertEquals((int)0, (int)warnings.get());
        }
        finally {
            log4jLogger.removeAppender((Appender)appender);
        }
    }

    private void fillQueue(final ActiveMQQueue queue) throws JMSException, InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        new Thread("Fill thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(1);
                    while (keepGoing.get()) {
                        done.set(false);
                        producer.send((Message)session.createTextMessage("Hello World"));
                    }
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        this.waitForBlockedOrResourceLimit(done);
        keepGoing.set(false);
    }

    protected void waitForBlockedOrResourceLimit(AtomicBoolean done) throws InterruptedException {
        while (true) {
            Thread.sleep(1000L);
            if (done.get() || this.gotResourceException.get()) break;
            done.set(true);
        }
    }

    private CountDownLatch asyncSendTo(final ActiveMQQueue queue, final String message) throws JMSException {
        final CountDownLatch done = new CountDownLatch(1);
        new Thread("Send thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    producer.setDeliveryMode(1);
                    producer.send((Message)session.createTextMessage(message));
                    done.countDown();
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        return done;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(1L);
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new VMPendingSubscriberMessageStoragePolicy());
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        policy.setProducerFlowControl(true);
        policyMap.setDefaultEntry(policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        for (Connection c : this.connections) {
            ActiveMQConnection connection = (ActiveMQConnection)c;
            TcpTransport t = (TcpTransport)connection.getTransport().narrow(TcpTransport.class);
            t.getTransportListener().onException(new IOException("Disposed."));
            connection.getTransport().stop();
        }
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

