/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TopicSubscriptionTest;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.StrictOrderDispatchPolicy;
import org.apache.activemq.util.MessageIdList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class StrictOrderDispatchPolicyTest
extends TopicSubscriptionTest {
    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy((DispatchPolicy)new StrictOrderDispatchPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    @Test
    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesOnePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesOnePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesLargePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesLargePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testOneProducerManyConsumersFewMessages() throws Exception {
        super.testOneProducerManyConsumersFewMessages();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testOneProducerManyConsumersManyMessages() throws Exception {
        super.testOneProducerManyConsumersManyMessages();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testManyProducersOneConsumer() throws Exception {
        super.testManyProducersOneConsumer();
        this.assertReceivedMessagesAreOrdered();
    }

    @Override
    @Test
    public void testManyProducersManyConsumers() throws Exception {
        super.testManyProducersManyConsumers();
        this.assertReceivedMessagesAreOrdered();
    }

    public void assertReceivedMessagesAreOrdered() throws Exception {
        if (this.consumers.size() <= 1) {
            return;
        }
        Iterator i = this.consumers.keySet().iterator();
        MessageIdList messageOrder = (MessageIdList)((Object)this.consumers.get(i.next()));
        while (i.hasNext()) {
            MessageIdList messageIdList = (MessageIdList)((Object)this.consumers.get(i.next()));
            Assert.assertTrue((String)"Messages are not ordered.", (boolean)messageOrder.equals((Object)messageIdList));
        }
    }
}

