/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueView;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuePurgeTest
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(QueuePurgeTest.class);
    private static final int NUM_TO_SEND = 20000;
    private final String MESSAGE_TEXT = new String(new byte[1024]);
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    Queue queue;
    MessageConsumer consumer;

    protected void setUp() throws Exception {
        this.setMaxTestTime(600000L);
        this.setAutoFail(true);
        super.setUp();
        this.broker = new BrokerService();
        File testDataDir = new File("target/activemq-data/QueuePurgeTest");
        this.broker.setDataDirectoryFile(testDataDir);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File(testDataDir, "kahadb"));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.consumer != null) {
            this.consumer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    public void testPurgeLargeQueue() throws Exception {
        this.testPurgeLargeQueue(false);
    }

    public void testPurgeLargeQueuePrioritizedMessages() throws Exception {
        this.testPurgeLargeQueue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPurgeLargeQueue(boolean prioritizedMessages) throws Exception {
        this.applyBrokerSpoolingPolicy(prioritizedMessages);
        this.createProducerAndSendMessages(20000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        LOG.info("purging..");
        org.apache.log4j.Logger log4jLogger = org.apache.log4j.Logger.getLogger(QueueView.class);
        final AtomicBoolean gotPurgeLogMessage = new AtomicBoolean(false);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                String message;
                if (event.getMessage() instanceof String && (message = (String)event.getMessage()).contains("purge of 20000 messages")) {
                    LOG.info("Received a log message: {} ", event.getMessage());
                    gotPurgeLogMessage.set(true);
                }
            }
        };
        Level level = log4jLogger.getLevel();
        log4jLogger.setLevel(Level.INFO);
        log4jLogger.addAppender((Appender)appender);
        try {
            proxy.purge();
        }
        finally {
            log4jLogger.setLevel(level);
            log4jLogger.removeAppender((Appender)appender);
        }
        QueuePurgeTest.assertEquals((String)("Queue size is not zero, it's " + proxy.getQueueSize()), (long)0L, (long)proxy.getQueueSize());
        QueuePurgeTest.assertTrue((String)"cache is disabled, temp store being used", (!proxy.isCacheEnabled() ? 1 : 0) != 0);
        QueuePurgeTest.assertTrue((String)"got expected info purge log message", (boolean)gotPurgeLogMessage.get());
        QueuePurgeTest.assertEquals((String)"Found messages when browsing", (int)0, (int)proxy.browseMessages().size());
    }

    public void testRepeatedExpiryProcessingOfLargeQueue() throws Exception {
        this.applyBrokerSpoolingPolicy(false);
        int expiryPeriod = 500;
        this.applyExpiryDuration(500);
        this.createProducerAndSendMessages(20000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        LOG.info("waiting for expiry to kick in a bunch of times to verify it does not blow mem");
        Thread.sleep(5000L);
        QueuePurgeTest.assertEquals((String)("Queue size is has not changed " + proxy.getQueueSize()), (long)20000L, (long)proxy.getQueueSize());
    }

    private void applyExpiryDuration(int i) {
        this.broker.getDestinationPolicy().getDefaultEntry().setExpireMessagesPeriod((long)i);
    }

    private void applyBrokerSpoolingPolicy(boolean prioritizedMessages) {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setPrioritizedMessages(prioritizedMessages);
        defaultEntry.setProducerFlowControl(false);
        FilePendingQueueMessageStoragePolicy pendingQueuePolicy = new FilePendingQueueMessageStoragePolicy();
        defaultEntry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)pendingQueuePolicy);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
    }

    public void testPurgeLargeQueueWithConsumer() throws Exception {
        this.testPurgeLargeQueueWithConsumer(false);
    }

    public void testPurgeLargeQueueWithConsumerPrioritizedMessages() throws Exception {
        this.testPurgeLargeQueueWithConsumer(true);
    }

    private void testPurgeLargeQueueWithConsumer(boolean prioritizedMessages) throws Exception {
        Message msg;
        this.applyBrokerSpoolingPolicy(prioritizedMessages);
        this.createProducerAndSendMessages(20000);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        this.createConsumer();
        long start = System.currentTimeMillis();
        LOG.info("purging..");
        proxy.purge();
        LOG.info("purge done: " + (System.currentTimeMillis() - start) + "ms");
        QueuePurgeTest.assertEquals((String)("Queue size is not zero, it's " + proxy.getQueueSize()), (long)0L, (long)proxy.getQueueSize());
        QueuePurgeTest.assertEquals((String)"usage goes to duck", (int)0, (int)proxy.getMemoryPercentUsage());
        do {
            if ((msg = this.consumer.receive(1000L)) == null) continue;
            msg.acknowledge();
        } while (msg != null);
        QueuePurgeTest.assertEquals((String)"Queue size not valid", (long)0L, (long)proxy.getQueueSize());
        QueuePurgeTest.assertEquals((String)"Found messages when browsing", (int)0, (int)proxy.browseMessages().size());
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.queue.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    private void createProducerAndSendMessages(int numToSend) throws Exception {
        this.session = this.connection.createSession(false, 2);
        this.queue = this.session.createQueue("test1");
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        for (int i = 0; i < numToSend; ++i) {
            TextMessage message = this.session.createTextMessage(this.MESSAGE_TEXT + i);
            if (i != 0 && i % 10000 == 0) {
                LOG.info("sent: " + i);
            }
            producer.send((Message)message);
        }
        producer.close();
    }

    private void createConsumer() throws Exception {
        this.consumer = this.session.createConsumer((Destination)this.queue);
        Thread.sleep(5000L);
        for (int i = 0; i < 500; ++i) {
            Message message = this.consumer.receive();
            message.acknowledge();
        }
    }
}

