/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PendingNode;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.util.IdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class OrderPendingListTest {
    @Test
    public void testAddMessageFirst() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        Iterator iter = list.iterator();
        int lastId = list.size();
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId--, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
    }

    @Test
    public void testAddMessageLast() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        list.addMessageLast((MessageReference)new TestMessageReference(1));
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        list.addMessageLast((MessageReference)new TestMessageReference(3));
        list.addMessageLast((MessageReference)new TestMessageReference(4));
        list.addMessageLast((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        Iterator iter = list.iterator();
        int lastId = 1;
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId++, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
    }

    @Test
    public void testClear() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)list.getAsList().size());
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        list.addMessageLast((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageLast((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
    }

    @Test
    public void testIsEmpty() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        Assert.assertTrue((boolean)list.isEmpty());
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertFalse((boolean)list.isEmpty());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testSize() {
        OrderedPendingList list = new OrderedPendingList();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        list.addMessageLast((MessageReference)new TestMessageReference(2));
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        list.addMessageLast((MessageReference)new TestMessageReference(4));
        Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)list.isEmpty());
        list.clear();
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        TestMessageReference toRemove = new TestMessageReference(6);
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        list.addMessageLast((MessageReference)toRemove);
        list.remove((MessageReference)toRemove);
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        list.remove((MessageReference)toRemove);
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        Iterator iter = list.iterator();
        int lastId = list.size();
        while (iter.hasNext()) {
            Assert.assertEquals((long)lastId--, (long)((MessageReference)iter.next()).getMessageId().getProducerSequenceId());
        }
        list.remove(null);
    }

    @Test
    public void testContains() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        TestMessageReference toRemove = new TestMessageReference(6);
        Assert.assertFalse((boolean)list.contains((MessageReference)toRemove));
        Assert.assertFalse((boolean)list.contains(null));
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
        list.addMessageLast((MessageReference)toRemove);
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains((MessageReference)toRemove));
        list.remove((MessageReference)toRemove);
        Assert.assertFalse((boolean)list.contains((MessageReference)toRemove));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)list.getAsList().size());
    }

    @Test
    public void testValues() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        TestMessageReference toRemove = new TestMessageReference(6);
        Assert.assertFalse((boolean)list.contains((MessageReference)toRemove));
        list.addMessageFirst((MessageReference)new TestMessageReference(1));
        list.addMessageFirst((MessageReference)new TestMessageReference(2));
        list.addMessageFirst((MessageReference)new TestMessageReference(3));
        list.addMessageFirst((MessageReference)new TestMessageReference(4));
        list.addMessageFirst((MessageReference)new TestMessageReference(5));
        Collection values = list.values();
        Assert.assertEquals((long)5L, (long)values.size());
        for (MessageReference msg : values) {
            Assert.assertTrue((boolean)values.contains(msg));
        }
        Assert.assertFalse((boolean)values.contains(toRemove));
        list.addMessageLast((MessageReference)toRemove);
        values = list.values();
        Assert.assertEquals((long)6L, (long)values.size());
        for (MessageReference msg : values) {
            Assert.assertTrue((boolean)values.contains(msg));
        }
        Assert.assertTrue((boolean)values.contains(toRemove));
    }

    @Test
    public void testAddAll() throws Exception {
        OrderedPendingList list = new OrderedPendingList();
        TestPendingList source = new TestPendingList();
        source.addMessageFirst(new TestMessageReference(1));
        source.addMessageFirst(new TestMessageReference(2));
        source.addMessageFirst(new TestMessageReference(3));
        source.addMessageFirst(new TestMessageReference(4));
        source.addMessageFirst(new TestMessageReference(5));
        Assert.assertTrue((boolean)list.isEmpty());
        Assert.assertEquals((long)5L, (long)source.size());
        list.addAll((PendingList)source);
        Assert.assertEquals((long)5L, (long)list.size());
        Iterator<MessageReference> i$ = source.iterator();
        while (i$.hasNext()) {
            MessageReference message = i$.next();
            Assert.assertTrue((boolean)list.contains(message));
        }
        list.addAll(null);
    }

    @Test
    public void testInsertAtHead() throws Exception {
        MessageReference ref;
        int i;
        OrderedPendingList underTest = new OrderedPendingList();
        TestPendingList source = new TestPendingList();
        source.addMessageLast(new TestMessageReference(1));
        source.addMessageLast(new TestMessageReference(2));
        source.addMessageLast(new TestMessageReference(3));
        source.addMessageLast(new TestMessageReference(4));
        source.addMessageLast(new TestMessageReference(5));
        Assert.assertTrue((boolean)underTest.isEmpty());
        Assert.assertEquals((long)5L, (long)source.size());
        LinkedList<MessageReference> linkedList = new LinkedList<MessageReference>();
        linkedList.addAll(source.values());
        underTest.insertAtHead(linkedList);
        Assert.assertEquals((long)5L, (long)underTest.size());
        underTest.insertAtHead(null);
        linkedList.clear();
        Iterator iterator = underTest.iterator();
        for (i = 0; i < 2 && iterator.hasNext(); ++i) {
            ref = (MessageReference)iterator.next();
            linkedList.addLast(ref);
            iterator.remove();
            Assert.assertEquals((long)ref.getMessageId().getProducerSequenceId(), (long)(i + 1));
        }
        Assert.assertEquals((long)3L, (long)underTest.size());
        underTest.insertAtHead(linkedList);
        Assert.assertEquals((long)5L, (long)underTest.size());
        iterator = underTest.iterator();
        i = 0;
        while (iterator.hasNext()) {
            ref = (MessageReference)iterator.next();
            linkedList.addLast(ref);
            iterator.remove();
            Assert.assertEquals((long)ref.getMessageId().getProducerSequenceId(), (long)(i + 1));
            ++i;
        }
        Assert.assertEquals((long)0L, (long)underTest.size());
    }

    static class TestMessageReference
    implements MessageReference {
        private static final IdGenerator id = new IdGenerator();
        private MessageId messageId;
        private int referenceCount = 0;

        public TestMessageReference(int sequenceId) {
            this.messageId = new MessageId(id.generateId() + ":1", (long)sequenceId);
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public Message getMessageHardRef() {
            return null;
        }

        public Message getMessage() {
            return null;
        }

        public boolean isPersistent() {
            return false;
        }

        public Destination getRegionDestination() {
            return null;
        }

        public int getRedeliveryCounter() {
            return 0;
        }

        public void incrementRedeliveryCounter() {
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public int incrementReferenceCount() {
            return this.referenceCount++;
        }

        public int decrementReferenceCount() {
            return this.referenceCount--;
        }

        public ConsumerId getTargetConsumerId() {
            return null;
        }

        public int getSize() {
            return 1;
        }

        public long getExpiration() {
            return 0L;
        }

        public String getGroupID() {
            return null;
        }

        public int getGroupSequence() {
            return 0;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isDropped() {
            return false;
        }

        public boolean isAdvisory() {
            return false;
        }

        public boolean canProcessAsExpired() {
            return false;
        }
    }

    static class TestPendingList
    implements PendingList {
        private final LinkedList<MessageReference> theList = new LinkedList();

        TestPendingList() {
        }

        public boolean isEmpty() {
            return this.theList.isEmpty();
        }

        public void clear() {
            this.theList.clear();
        }

        public PendingNode addMessageFirst(MessageReference message) {
            this.theList.addFirst(message);
            return new PendingNode(null, message);
        }

        public PendingNode addMessageLast(MessageReference message) {
            this.theList.addLast(message);
            return new PendingNode(null, message);
        }

        public PendingNode remove(MessageReference message) {
            if (this.theList.remove(message)) {
                return new PendingNode(null, message);
            }
            return null;
        }

        public int size() {
            return this.theList.size();
        }

        public Iterator<MessageReference> iterator() {
            return this.theList.iterator();
        }

        public boolean contains(MessageReference message) {
            return this.theList.contains(message);
        }

        public Collection<MessageReference> values() {
            return this.theList;
        }

        public void addAll(PendingList pendingList) {
            for (MessageReference messageReference : pendingList) {
                this.theList.add(messageReference);
            }
        }

        public MessageReference get(MessageId messageId) {
            for (MessageReference messageReference : this.theList) {
                if (!messageReference.getMessageId().equals((Object)messageId)) continue;
                return messageReference;
            }
            return null;
        }
    }
}

