/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.ConsumerThread;
import org.apache.activemq.util.ProducerThread;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSSLLoadTest {
    private static final Logger LOG = LoggerFactory.getLogger(NIOSSLLoadTest.class);
    BrokerService broker;
    Connection connection;
    Session session;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    public static final int PRODUCER_COUNT = 10;
    public static final int CONSUMER_COUNT = 10;
    public static final int MESSAGE_COUNT = 1000;
    final ConsumerThread[] consumers = new ConsumerThread[10];
    TransportConnector connector;

    @Before
    public void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.connector = this.broker.addConnector("nio+ssl://localhost:0?transport.needClientAuth=true&transport.enabledCipherSuites=SSL_RSA_WITH_RC4_128_SHA,SSL_DH_anon_WITH_3DES_EDE_CBC_SHA");
        this.broker.start();
        this.broker.waitUntilStarted();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + this.connector.getConnectUri().getPort());
        this.connection = factory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testLoad() throws Exception {
        int i;
        Queue dest = this.session.createQueue("TEST");
        for (i = 0; i < 10; ++i) {
            ProducerThread producer = new ProducerThread(this.session, (Destination)dest);
            producer.setMessageCount(1000);
            producer.start();
        }
        for (i = 0; i < 10; ++i) {
            ConsumerThread consumer = new ConsumerThread(this.session, (Destination)dest);
            consumer.setMessageCount(1000);
            consumer.start();
            this.consumers[i] = consumer;
        }
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return NIOSSLLoadTest.this.getReceived() == 10000;
            }
        }, (long)60000L);
        Assert.assertEquals((long)10000L, (long)this.getReceived());
    }

    @Test(timeout=360000L)
    @Ignore
    public void testConnectionHandshakeLoad() throws Exception {
        final ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + this.connector.getConnectUri().getPort());
        int threadNumber = 500;
        final CountDownLatch latch = new CountDownLatch(threadNumber);
        final AtomicInteger errors = new AtomicInteger(0);
        final Random rand = new Random();
        for (int i = 0; i < threadNumber; ++i) {
            Thread thread = new Thread("thread " + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (int i = 0; i < 100; ++i) {
                        Connection conn = null;
                        try {
                            conn = factory.createConnection();
                            conn.start();
                            Session sess = conn.createSession(false, 1);
                            int sleepTime = rand.nextInt(2001) + 1000;
                            LOG.info(this.getName() + " sleeping " + sleepTime);
                            Thread.sleep(sleepTime);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                            continue;
                        }
                        finally {
                            try {
                                conn.close();
                            }
                            catch (Exception exception) {}
                            LOG.info(this.getName() + " iteration " + i);
                        }
                    }
                    LOG.info(this.getName() + " finished");
                    latch.countDown();
                }
            };
            thread.start();
        }
        latch.await(5L, TimeUnit.MINUTES);
        LOG.info("errors " + errors.get());
    }

    protected int getReceived() {
        int received = 0;
        for (ConsumerThread consumer : this.consumers) {
            received += consumer.getReceived();
        }
        return received;
    }
}

